/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */
  

#ifdef __SUNPRO_C
#pragma ident	"@(#)mlib_c_ImageConvVersion.c	1.2	02/04/19 SMI"
#endif /* __SUNPRO_C */

/*
 * FUNCTION
 *      mlib_ImageConvVersion - Get Conv* funtions version
 *      0  - "C" version
 *      1  - "VIS" version
 *      2  - "i386" version
 *      3  - "MMX" version
 *
 * SYNOPSIS
 *      mlib_s32 mlib_ImageConvVersion(mlib_s32 m,
 *                                     mlib_s32 n,
 *                                     mlib_s32 scale,
 *                                     mlib_type type)
 *
 */

#include "mlib_image.h"

#define MAX_U8   8
#define MAX_S16 32

/***************************************************************/
mlib_s32 mlib_ImageConvVersion(mlib_s32 m,
                               mlib_s32 n,
                               mlib_s32 scale,
                               mlib_type type)
{
#ifdef __sparc
  return 0;
#else
  mlib_d64 dscale = 1.0 / (1 << scale); /* 16 < scale <= 31 */

  if (type == MLIB_BYTE) {
    if ((m * n * dscale * 32768.0) > MAX_U8)
      return 0;
    return 2;
  }
  else if ((type == MLIB_USHORT) || (type == MLIB_SHORT)) {

    if ((m * n * dscale * 32768.0 * 32768.0) > MAX_S16)
      return 0;
    return 2;
  }
  else
    return 0;
#endif /* __sparc */
}

/***************************************************************/
