/*
 * Copyright 2005-2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 4936763
 * @summary Verify that DHKeyAgreement can generate secret key
 * objects for AES algorithm
 * @author Valerie Peng
 */
import java.security.*;
import java.security.interfaces.*;
import javax.crypto.*;

public class DHGenSecretKey {

    public static void main(String[] args) throws Exception {
	DHGenSecretKey test = new DHGenSecretKey();
	test.run();
    }

    public void run() throws Exception {
	// generate keyPairs using parameters
	KeyPairGenerator keyGen =
	    KeyPairGenerator.getInstance("DH", "SunJCE");

	// Alice generates her key pairs
	KeyPair keyA = keyGen.generateKeyPair();

	// Bob generates his key pairs
	KeyPair keyB = keyGen.generateKeyPair();

	KeyAgreement bobAlice = KeyAgreement.getInstance("DH", "SunJCE");
	bobAlice.init(keyB.getPrivate());
	bobAlice.doPhase(keyA.getPublic(), true);
	byte[] keyMaterial = bobAlice.generateSecret();

	bobAlice.doPhase(keyA.getPublic(), true);
	SecretKey skey = bobAlice.generateSecret("AES");
	byte[] keyVal = skey.getEncoded();

	System.out.println("Generated " + keyVal.length*8 +
	    "-bit AES key");
	for (int i = 0; i < keyVal.length; i++) {
	    if (keyVal[i] != keyMaterial[i]) {
		throw new Exception("Error: key value comparison failed!");
	    }
	}
	System.out.println("Test Passed");
    }
}
