/*
 * Copyright 2005 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * build     @BUILD_TAG_PLACEHOLDER@
 *
 * @COPYRIGHT_MINI_LEGAL_NOTICE_PLACEHOLDER@
 */
/*
 * MBeanFeatureInfoSerialStore
 *
 * Generated on December 9, 2005  by dfuchs 
 *   with JRE: Sun Microsystems Inc. 1.5.0_05 
 *
 */



import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.management.MBeanFeatureInfo;

/**
 * The class MBeanFeatureInfoSerialStore is a static store of MBeanFeatureInfo instances 
 * serialized with java version 1.5.0_05.
 * It is used to check serial compatibility with later version of the 
 * JDK.
 **/
public class MBeanFeatureInfoSerialStore {

    // The serial object store.
    //
    private static final Map<String,byte[]> map = 
            new HashMap<String,byte[]>();
    static {
        // initialization of serial store
       // floatAttr:  javax.management.openmbean.OpenMBeanAttributeInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,65,116,116,114,105,98,
                117,116,101,73,110,102,111,83,117,112,
                112,111,114,116,-68,116,45,45,-28,-120,
                -79,7,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,65,116,116,114,105,98,117,116,
                101,73,110,102,111,119,-8,41,59,106,
                41,68,-40,2,0,4,90,0,2,105,
                115,90,0,6,105,115,82,101,97,100,
                90,0,7,105,115,87,114,105,116,101,
                76,0,13,97,116,116,114,105,98,117,
                116,101,84,121,112,101,116,0,18,76,
                106,97,118,97,47,108,97,110,103,47,
                83,116,114,105,110,103,59,120,114,0,
                33,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,70,101,97,116,117,114,101,
                73,110,102,111,54,-37,117,-36,-62,-63,
                85,33,2,0,2,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,4,110,97,109,
                101,113,0,126,0,6,120,112,116,0,
                5,100,101,115,99,114,116,0,9,102,
                108,111,97,116,65,116,116,114,0,1,
                1,116,0,15,106,97,118,97,46,108,
                97,110,103,46,70,108,111,97,116,115,
                114,0,15,106,97,118,97,46,108,97,
                110,103,46,70,108,111,97,116,-38,-19,
                -55,-94,-37,60,-16,-20,2,0,1,70,
                0,5,118,97,108,117,101,120,114,0,
                16,106,97,118,97,46,108,97,110,103,
                46,78,117,109,98,101,114,-122,-84,-107,
                29,11,-108,-32,-117,2,0,0,120,112,
                63,-128,0,0,112,115,113,0,126,0,
                12,64,0,0,0,115,113,0,126,0,
                12,0,0,0,0,115,114,0,37,106,
                97,118,97,120,46,109,97,110,97,103,
                101,109,101,110,116,46,111,112,101,110,
                109,98,101,97,110,46,83,105,109,112,
                108,101,84,121,112,101,30,-65,79,-8,
                -36,101,120,39,2,0,0,120,114,0,
                35,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,111,112,
                101,110,109,98,101,97,110,46,79,112,
                101,110,84,121,112,101,-128,100,26,-111,
                -23,-22,-34,60,2,0,3,76,0,9,
                99,108,97,115,115,78,97,109,101,113,
                0,126,0,6,76,0,11,100,101,115,
                99,114,105,112,116,105,111,110,113,0,
                126,0,6,76,0,8,116,121,112,101,
                78,97,109,101,113,0,126,0,6,120,
                112,113,0,126,0,11,113,0,126,0,
                11,113,0,126,0,11
            };
            map.put("floatAttr",bytes);
        }
       // intAttr:  javax.management.openmbean.OpenMBeanAttributeInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,65,116,116,114,105,98,
                117,116,101,73,110,102,111,83,117,112,
                112,111,114,116,-68,116,45,45,-28,-120,
                -79,7,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,65,116,116,114,105,98,117,116,
                101,73,110,102,111,119,-8,41,59,106,
                41,68,-40,2,0,4,90,0,2,105,
                115,90,0,6,105,115,82,101,97,100,
                90,0,7,105,115,87,114,105,116,101,
                76,0,13,97,116,116,114,105,98,117,
                116,101,84,121,112,101,116,0,18,76,
                106,97,118,97,47,108,97,110,103,47,
                83,116,114,105,110,103,59,120,114,0,
                33,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,70,101,97,116,117,114,101,
                73,110,102,111,54,-37,117,-36,-62,-63,
                85,33,2,0,2,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,4,110,97,109,
                101,113,0,126,0,6,120,112,116,0,
                5,100,101,115,99,114,116,0,7,105,
                110,116,65,116,116,114,0,0,1,116,
                0,17,106,97,118,97,46,108,97,110,
                103,46,73,110,116,101,103,101,114,112,
                112,112,112,115,114,0,37,106,97,118,
                97,120,46,109,97,110,97,103,101,109,
                101,110,116,46,111,112,101,110,109,98,
                101,97,110,46,83,105,109,112,108,101,
                84,121,112,101,30,-65,79,-8,-36,101,
                120,39,2,0,0,120,114,0,35,106,
                97,118,97,120,46,109,97,110,97,103,
                101,109,101,110,116,46,111,112,101,110,
                109,98,101,97,110,46,79,112,101,110,
                84,121,112,101,-128,100,26,-111,-23,-22,
                -34,60,2,0,3,76,0,9,99,108,
                97,115,115,78,97,109,101,113,0,126,
                0,6,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,8,116,121,112,101,78,97,
                109,101,113,0,126,0,6,120,112,113,
                0,126,0,11,113,0,126,0,11,113,
                0,126,0,11
            };
            map.put("intAttr",bytes);
        }
       // arrayOp:  javax.management.openmbean.OpenMBeanOperationInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,79,112,101,114,97,116,
                105,111,110,73,110,102,111,83,117,112,
                112,111,114,116,69,88,105,115,-56,3,
                34,22,2,0,1,76,0,14,114,101,
                116,117,114,110,79,112,101,110,84,121,
                112,101,116,0,37,76,106,97,118,97,
                120,47,109,97,110,97,103,101,109,101,
                110,116,47,111,112,101,110,109,98,101,
                97,110,47,79,112,101,110,84,121,112,
                101,59,120,114,0,35,106,97,118,97,
                120,46,109,97,110,97,103,101,109,101,
                110,116,46,77,66,101,97,110,79,112,
                101,114,97,116,105,111,110,73,110,102,
                111,-86,64,71,34,-107,-2,-125,-98,2,
                0,3,73,0,6,105,109,112,97,99,
                116,91,0,9,115,105,103,110,97,116,
                117,114,101,116,0,38,91,76,106,97,
                118,97,120,47,109,97,110,97,103,101,
                109,101,110,116,47,77,66,101,97,110,
                80,97,114,97,109,101,116,101,114,73,
                110,102,111,59,76,0,4,116,121,112,
                101,116,0,18,76,106,97,118,97,47,
                108,97,110,103,47,83,116,114,105,110,
                103,59,120,114,0,33,106,97,118,97,
                120,46,109,97,110,97,103,101,109,101,
                110,116,46,77,66,101,97,110,70,101,
                97,116,117,114,101,73,110,102,111,54,
                -37,117,-36,-62,-63,85,33,2,0,2,
                76,0,11,100,101,115,99,114,105,112,
                116,105,111,110,113,0,126,0,4,76,
                0,4,110,97,109,101,113,0,126,0,
                4,120,112,116,0,5,100,101,115,99,
                114,116,0,7,97,114,114,97,121,79,
                112,0,0,0,1,117,114,0,38,91,
                76,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,80,97,114,97,109,101,116,
                101,114,73,110,102,111,59,-51,104,101,
                54,3,-80,-18,54,2,0,0,120,112,
                0,0,0,0,116,0,20,91,76,106,
                97,118,97,46,108,97,110,103,46,73,
                110,116,101,103,101,114,59,115,114,0,
                36,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,111,112,
                101,110,109,98,101,97,110,46,65,114,
                114,97,121,84,121,112,101,9,-1,-66,
                -10,39,33,-121,-118,2,0,2,73,0,
                9,100,105,109,101,110,115,105,111,110,
                76,0,11,101,108,101,109,101,110,116,
                84,121,112,101,113,0,126,0,1,120,
                114,0,35,106,97,118,97,120,46,109,
                97,110,97,103,101,109,101,110,116,46,
                111,112,101,110,109,98,101,97,110,46,
                79,112,101,110,84,121,112,101,-128,100,
                26,-111,-23,-22,-34,60,2,0,3,76,
                0,9,99,108,97,115,115,78,97,109,
                101,113,0,126,0,4,76,0,11,100,
                101,115,99,114,105,112,116,105,111,110,
                113,0,126,0,4,76,0,8,116,121,
                112,101,78,97,109,101,113,0,126,0,
                4,120,112,113,0,126,0,11,116,0,
                38,49,45,100,105,109,101,110,115,105,
                111,110,32,97,114,114,97,121,32,111,
                102,32,106,97,118,97,46,108,97,110,
                103,46,73,110,116,101,103,101,114,116,
                0,20,91,76,106,97,118,97,46,108,
                97,110,103,46,73,110,116,101,103,101,
                114,59,0,0,0,1,115,114,0,37,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,111,112,101,
                110,109,98,101,97,110,46,83,105,109,
                112,108,101,84,121,112,101,30,-65,79,
                -8,-36,101,120,39,2,0,0,120,113,
                0,126,0,13,116,0,17,106,97,118,
                97,46,108,97,110,103,46,73,110,116,
                101,103,101,114,113,0,126,0,19,113,
                0,126,0,19
            };
            map.put("arrayOp",bytes);
        }
       // intPar:  javax.management.openmbean.OpenMBeanParameterInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,80,97,114,97,109,101,
                116,101,114,73,110,102,111,83,117,112,
                112,111,114,116,-101,-104,14,124,111,-85,
                -71,-114,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,80,97,114,97,109,101,116,101,
                114,73,110,102,111,103,37,-11,-84,-39,
                123,54,2,2,0,1,76,0,4,116,
                121,112,101,116,0,18,76,106,97,118,
                97,47,108,97,110,103,47,83,116,114,
                105,110,103,59,120,114,0,33,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,77,66,101,97,110,
                70,101,97,116,117,114,101,73,110,102,
                111,54,-37,117,-36,-62,-63,85,33,2,
                0,2,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,4,110,97,109,101,113,0,
                126,0,6,120,112,116,0,5,100,101,
                115,99,114,116,0,6,105,110,116,80,
                97,114,116,0,17,106,97,118,97,46,
                108,97,110,103,46,73,110,116,101,103,
                101,114,112,112,112,112,115,114,0,37,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,111,112,101,
                110,109,98,101,97,110,46,83,105,109,
                112,108,101,84,121,112,101,30,-65,79,
                -8,-36,101,120,39,2,0,0,120,114,
                0,35,106,97,118,97,120,46,109,97,
                110,97,103,101,109,101,110,116,46,111,
                112,101,110,109,98,101,97,110,46,79,
                112,101,110,84,121,112,101,-128,100,26,
                -111,-23,-22,-34,60,2,0,3,76,0,
                9,99,108,97,115,115,78,97,109,101,
                113,0,126,0,6,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,8,116,121,112,
                101,78,97,109,101,113,0,126,0,6,
                120,112,113,0,126,0,11,113,0,126,
                0,11,113,0,126,0,11
            };
            map.put("intPar",bytes);
        }
       // boolPar:  javax.management.openmbean.OpenMBeanParameterInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,80,97,114,97,109,101,
                116,101,114,73,110,102,111,83,117,112,
                112,111,114,116,-101,-104,14,124,111,-85,
                -71,-114,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,80,97,114,97,109,101,116,101,
                114,73,110,102,111,103,37,-11,-84,-39,
                123,54,2,2,0,1,76,0,4,116,
                121,112,101,116,0,18,76,106,97,118,
                97,47,108,97,110,103,47,83,116,114,
                105,110,103,59,120,114,0,33,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,77,66,101,97,110,
                70,101,97,116,117,114,101,73,110,102,
                111,54,-37,117,-36,-62,-63,85,33,2,
                0,2,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,4,110,97,109,101,113,0,
                126,0,6,120,112,116,0,5,100,101,
                115,99,114,116,0,7,98,111,111,108,
                80,97,114,116,0,17,106,97,118,97,
                46,108,97,110,103,46,66,111,111,108,
                101,97,110,115,114,0,17,106,97,118,
                97,46,108,97,110,103,46,66,111,111,
                108,101,97,110,-51,32,114,-128,-43,-100,
                -6,-18,2,0,1,90,0,5,118,97,
                108,117,101,120,112,1,112,112,112,115,
                114,0,37,106,97,118,97,120,46,109,
                97,110,97,103,101,109,101,110,116,46,
                111,112,101,110,109,98,101,97,110,46,
                83,105,109,112,108,101,84,121,112,101,
                30,-65,79,-8,-36,101,120,39,2,0,
                0,120,114,0,35,106,97,118,97,120,
                46,109,97,110,97,103,101,109,101,110,
                116,46,111,112,101,110,109,98,101,97,
                110,46,79,112,101,110,84,121,112,101,
                -128,100,26,-111,-23,-22,-34,60,2,0,
                3,76,0,9,99,108,97,115,115,78,
                97,109,101,113,0,126,0,6,76,0,
                11,100,101,115,99,114,105,112,116,105,
                111,110,113,0,126,0,6,76,0,8,
                116,121,112,101,78,97,109,101,113,0,
                126,0,6,120,112,113,0,126,0,11,
                113,0,126,0,11,113,0,126,0,11
            };
            map.put("boolPar",bytes);
        }
       // findWombat:  javax.management.openmbean.OpenMBeanOperationInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,79,112,101,114,97,116,
                105,111,110,73,110,102,111,83,117,112,
                112,111,114,116,69,88,105,115,-56,3,
                34,22,2,0,1,76,0,14,114,101,
                116,117,114,110,79,112,101,110,84,121,
                112,101,116,0,37,76,106,97,118,97,
                120,47,109,97,110,97,103,101,109,101,
                110,116,47,111,112,101,110,109,98,101,
                97,110,47,79,112,101,110,84,121,112,
                101,59,120,114,0,35,106,97,118,97,
                120,46,109,97,110,97,103,101,109,101,
                110,116,46,77,66,101,97,110,79,112,
                101,114,97,116,105,111,110,73,110,102,
                111,-86,64,71,34,-107,-2,-125,-98,2,
                0,3,73,0,6,105,109,112,97,99,
                116,91,0,9,115,105,103,110,97,116,
                117,114,101,116,0,38,91,76,106,97,
                118,97,120,47,109,97,110,97,103,101,
                109,101,110,116,47,77,66,101,97,110,
                80,97,114,97,109,101,116,101,114,73,
                110,102,111,59,76,0,4,116,121,112,
                101,116,0,18,76,106,97,118,97,47,
                108,97,110,103,47,83,116,114,105,110,
                103,59,120,114,0,33,106,97,118,97,
                120,46,109,97,110,97,103,101,109,101,
                110,116,46,77,66,101,97,110,70,101,
                97,116,117,114,101,73,110,102,111,54,
                -37,117,-36,-62,-63,85,33,2,0,2,
                76,0,11,100,101,115,99,114,105,112,
                116,105,111,110,113,0,126,0,4,76,
                0,4,110,97,109,101,113,0,126,0,
                4,120,112,116,0,36,84,104,105,115,
                32,109,101,116,104,111,100,32,108,111,
                111,107,115,32,102,111,114,32,87,111,
                109,98,97,116,32,105,110,32,106,97,
                114,115,116,0,10,102,105,110,100,87,
                111,109,98,97,116,0,0,0,2,117,
                114,0,38,91,76,106,97,118,97,120,
                46,109,97,110,97,103,101,109,101,110,
                116,46,77,66,101,97,110,80,97,114,
                97,109,101,116,101,114,73,110,102,111,
                59,-51,104,101,54,3,-80,-18,54,2,
                0,0,120,112,0,0,0,1,115,114,
                0,56,106,97,118,97,120,46,109,97,
                110,97,103,101,109,101,110,116,46,111,
                112,101,110,109,98,101,97,110,46,79,
                112,101,110,77,66,101,97,110,80,97,
                114,97,109,101,116,101,114,73,110,102,
                111,83,117,112,112,111,114,116,-101,-104,
                14,124,111,-85,-71,-114,2,0,5,76,
                0,12,100,101,102,97,117,108,116,86,
                97,108,117,101,116,0,18,76,106,97,
                118,97,47,108,97,110,103,47,79,98,
                106,101,99,116,59,76,0,11,108,101,
                103,97,108,86,97,108,117,101,115,116,
                0,15,76,106,97,118,97,47,117,116,
                105,108,47,83,101,116,59,76,0,8,
                109,97,120,86,97,108,117,101,116,0,
                22,76,106,97,118,97,47,108,97,110,
                103,47,67,111,109,112,97,114,97,98,
                108,101,59,76,0,8,109,105,110,86,
                97,108,117,101,113,0,126,0,14,76,
                0,8,111,112,101,110,84,121,112,101,
                113,0,126,0,1,120,114,0,35,106,
                97,118,97,120,46,109,97,110,97,103,
                101,109,101,110,116,46,77,66,101,97,
                110,80,97,114,97,109,101,116,101,114,
                73,110,102,111,103,37,-11,-84,-39,123,
                54,2,2,0,1,76,0,4,116,121,
                112,101,113,0,126,0,4,120,113,0,
                126,0,5,116,0,23,97,106,97,114,
                32,109,117,115,116,32,110,111,116,32,
                98,101,32,115,101,97,108,101,100,116,
                0,4,97,106,97,114,116,0,16,106,
                97,118,97,46,108,97,110,103,46,83,
                116,114,105,110,103,116,0,12,110,111,
                119,111,109,98,97,116,46,106,97,114,
                112,112,112,115,114,0,37,106,97,118,
                97,120,46,109,97,110,97,103,101,109,
                101,110,116,46,111,112,101,110,109,98,
                101,97,110,46,83,105,109,112,108,101,
                84,121,112,101,30,-65,79,-8,-36,101,
                120,39,2,0,0,120,114,0,35,106,
                97,118,97,120,46,109,97,110,97,103,
                101,109,101,110,116,46,111,112,101,110,
                109,98,101,97,110,46,79,112,101,110,
                84,121,112,101,-128,100,26,-111,-23,-22,
                -34,60,2,0,3,76,0,9,99,108,
                97,115,115,78,97,109,101,113,0,126,
                0,4,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                4,76,0,8,116,121,112,101,78,97,
                109,101,113,0,126,0,4,120,112,113,
                0,126,0,19,113,0,126,0,19,113,
                0,126,0,19,116,0,17,106,97,118,
                97,46,108,97,110,103,46,66,111,111,
                108,101,97,110,115,113,0,126,0,21,
                113,0,126,0,24,113,0,126,0,24,
                113,0,126,0,24
            };
            map.put("findWombat",bytes);
        }
       // stringAttr:  javax.management.openmbean.OpenMBeanAttributeInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,65,116,116,114,105,98,
                117,116,101,73,110,102,111,83,117,112,
                112,111,114,116,-68,116,45,45,-28,-120,
                -79,7,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,65,116,116,114,105,98,117,116,
                101,73,110,102,111,119,-8,41,59,106,
                41,68,-40,2,0,4,90,0,2,105,
                115,90,0,6,105,115,82,101,97,100,
                90,0,7,105,115,87,114,105,116,101,
                76,0,13,97,116,116,114,105,98,117,
                116,101,84,121,112,101,116,0,18,76,
                106,97,118,97,47,108,97,110,103,47,
                83,116,114,105,110,103,59,120,114,0,
                33,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,70,101,97,116,117,114,101,
                73,110,102,111,54,-37,117,-36,-62,-63,
                85,33,2,0,2,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,4,110,97,109,
                101,113,0,126,0,6,120,112,116,0,
                5,100,101,115,99,114,116,0,10,115,
                116,114,105,110,103,65,116,116,114,0,
                1,0,116,0,16,106,97,118,97,46,
                108,97,110,103,46,83,116,114,105,110,
                103,112,112,112,112,115,114,0,37,106,
                97,118,97,120,46,109,97,110,97,103,
                101,109,101,110,116,46,111,112,101,110,
                109,98,101,97,110,46,83,105,109,112,
                108,101,84,121,112,101,30,-65,79,-8,
                -36,101,120,39,2,0,0,120,114,0,
                35,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,111,112,
                101,110,109,98,101,97,110,46,79,112,
                101,110,84,121,112,101,-128,100,26,-111,
                -23,-22,-34,60,2,0,3,76,0,9,
                99,108,97,115,115,78,97,109,101,113,
                0,126,0,6,76,0,11,100,101,115,
                99,114,105,112,116,105,111,110,113,0,
                126,0,6,76,0,8,116,121,112,101,
                78,97,109,101,113,0,126,0,6,120,
                112,113,0,126,0,11,113,0,126,0,
                11,113,0,126,0,11
            };
            map.put("stringAttr",bytes);
        }
       // datePar:  javax.management.openmbean.OpenMBeanParameterInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,80,97,114,97,109,101,
                116,101,114,73,110,102,111,83,117,112,
                112,111,114,116,-101,-104,14,124,111,-85,
                -71,-114,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,80,97,114,97,109,101,116,101,
                114,73,110,102,111,103,37,-11,-84,-39,
                123,54,2,2,0,1,76,0,4,116,
                121,112,101,116,0,18,76,106,97,118,
                97,47,108,97,110,103,47,83,116,114,
                105,110,103,59,120,114,0,33,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,77,66,101,97,110,
                70,101,97,116,117,114,101,73,110,102,
                111,54,-37,117,-36,-62,-63,85,33,2,
                0,2,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,4,110,97,109,101,113,0,
                126,0,6,120,112,116,0,5,100,101,
                115,99,114,116,0,7,100,97,116,101,
                80,97,114,116,0,14,106,97,118,97,
                46,117,116,105,108,46,68,97,116,101,
                115,114,0,14,106,97,118,97,46,117,
                116,105,108,46,68,97,116,101,104,106,
                -127,1,75,89,116,25,3,0,0,120,
                112,119,8,0,0,1,8,16,-111,109,
                114,120,115,114,0,37,106,97,118,97,
                46,117,116,105,108,46,67,111,108,108,
                101,99,116,105,111,110,115,36,85,110,
                109,111,100,105,102,105,97,98,108,101,
                83,101,116,-128,29,-110,-47,-113,-101,-128,
                85,2,0,0,120,114,0,44,106,97,
                118,97,46,117,116,105,108,46,67,111,
                108,108,101,99,116,105,111,110,115,36,
                85,110,109,111,100,105,102,105,97,98,
                108,101,67,111,108,108,101,99,116,105,
                111,110,25,66,0,-128,-53,94,-9,30,
                2,0,1,76,0,1,99,116,0,22,
                76,106,97,118,97,47,117,116,105,108,
                47,67,111,108,108,101,99,116,105,111,
                110,59,120,112,115,114,0,17,106,97,
                118,97,46,117,116,105,108,46,72,97,
                115,104,83,101,116,-70,68,-123,-107,-106,
                -72,-73,52,3,0,0,120,112,119,12,
                0,0,0,4,63,-128,0,0,0,0,
                0,2,115,113,0,126,0,12,119,8,
                0,0,1,8,11,107,17,114,120,113,
                0,126,0,13,120,112,112,115,114,0,
                37,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,111,112,
                101,110,109,98,101,97,110,46,83,105,
                109,112,108,101,84,121,112,101,30,-65,
                79,-8,-36,101,120,39,2,0,0,120,
                114,0,35,106,97,118,97,120,46,109,
                97,110,97,103,101,109,101,110,116,46,
                111,112,101,110,109,98,101,97,110,46,
                79,112,101,110,84,121,112,101,-128,100,
                26,-111,-23,-22,-34,60,2,0,3,76,
                0,9,99,108,97,115,115,78,97,109,
                101,113,0,126,0,6,76,0,11,100,
                101,115,99,114,105,112,116,105,111,110,
                113,0,126,0,6,76,0,8,116,121,
                112,101,78,97,109,101,113,0,126,0,
                6,120,112,113,0,126,0,11,113,0,
                126,0,11,113,0,126,0,11
            };
            map.put("datePar",bytes);
        }
       // dateAttr:  javax.management.openmbean.OpenMBeanAttributeInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,65,116,116,114,105,98,
                117,116,101,73,110,102,111,83,117,112,
                112,111,114,116,-68,116,45,45,-28,-120,
                -79,7,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,65,116,116,114,105,98,117,116,
                101,73,110,102,111,119,-8,41,59,106,
                41,68,-40,2,0,4,90,0,2,105,
                115,90,0,6,105,115,82,101,97,100,
                90,0,7,105,115,87,114,105,116,101,
                76,0,13,97,116,116,114,105,98,117,
                116,101,84,121,112,101,116,0,18,76,
                106,97,118,97,47,108,97,110,103,47,
                83,116,114,105,110,103,59,120,114,0,
                33,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,70,101,97,116,117,114,101,
                73,110,102,111,54,-37,117,-36,-62,-63,
                85,33,2,0,2,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,4,110,97,109,
                101,113,0,126,0,6,120,112,116,0,
                5,100,101,115,99,114,116,0,8,100,
                97,116,101,65,116,116,114,0,1,0,
                116,0,14,106,97,118,97,46,117,116,
                105,108,46,68,97,116,101,115,114,0,
                14,106,97,118,97,46,117,116,105,108,
                46,68,97,116,101,104,106,-127,1,75,
                89,116,25,3,0,0,120,112,119,8,
                0,0,1,8,16,-111,109,114,120,115,
                114,0,37,106,97,118,97,46,117,116,
                105,108,46,67,111,108,108,101,99,116,
                105,111,110,115,36,85,110,109,111,100,
                105,102,105,97,98,108,101,83,101,116,
                -128,29,-110,-47,-113,-101,-128,85,2,0,
                0,120,114,0,44,106,97,118,97,46,
                117,116,105,108,46,67,111,108,108,101,
                99,116,105,111,110,115,36,85,110,109,
                111,100,105,102,105,97,98,108,101,67,
                111,108,108,101,99,116,105,111,110,25,
                66,0,-128,-53,94,-9,30,2,0,1,
                76,0,1,99,116,0,22,76,106,97,
                118,97,47,117,116,105,108,47,67,111,
                108,108,101,99,116,105,111,110,59,120,
                112,115,114,0,17,106,97,118,97,46,
                117,116,105,108,46,72,97,115,104,83,
                101,116,-70,68,-123,-107,-106,-72,-73,52,
                3,0,0,120,112,119,12,0,0,0,
                4,63,-128,0,0,0,0,0,2,115,
                113,0,126,0,12,119,8,0,0,1,
                8,11,107,17,114,120,113,0,126,0,
                13,120,112,112,115,114,0,37,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,83,105,109,112,108,
                101,84,121,112,101,30,-65,79,-8,-36,
                101,120,39,2,0,0,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,111,112,101,
                110,109,98,101,97,110,46,79,112,101,
                110,84,121,112,101,-128,100,26,-111,-23,
                -22,-34,60,2,0,3,76,0,9,99,
                108,97,115,115,78,97,109,101,113,0,
                126,0,6,76,0,11,100,101,115,99,
                114,105,112,116,105,111,110,113,0,126,
                0,6,76,0,8,116,121,112,101,78,
                97,109,101,113,0,126,0,6,120,112,
                113,0,126,0,11,113,0,126,0,11,
                113,0,126,0,11
            };
            map.put("dateAttr",bytes);
        }
       // stringPar:  javax.management.openmbean.OpenMBeanParameterInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,80,97,114,97,109,101,
                116,101,114,73,110,102,111,83,117,112,
                112,111,114,116,-101,-104,14,124,111,-85,
                -71,-114,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,80,97,114,97,109,101,116,101,
                114,73,110,102,111,103,37,-11,-84,-39,
                123,54,2,2,0,1,76,0,4,116,
                121,112,101,116,0,18,76,106,97,118,
                97,47,108,97,110,103,47,83,116,114,
                105,110,103,59,120,114,0,33,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,77,66,101,97,110,
                70,101,97,116,117,114,101,73,110,102,
                111,54,-37,117,-36,-62,-63,85,33,2,
                0,2,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,4,110,97,109,101,113,0,
                126,0,6,120,112,116,0,5,100,101,
                115,99,114,116,0,9,115,116,114,105,
                110,103,80,97,114,116,0,16,106,97,
                118,97,46,108,97,110,103,46,83,116,
                114,105,110,103,112,112,112,112,115,114,
                0,37,106,97,118,97,120,46,109,97,
                110,97,103,101,109,101,110,116,46,111,
                112,101,110,109,98,101,97,110,46,83,
                105,109,112,108,101,84,121,112,101,30,
                -65,79,-8,-36,101,120,39,2,0,0,
                120,114,0,35,106,97,118,97,120,46,
                109,97,110,97,103,101,109,101,110,116,
                46,111,112,101,110,109,98,101,97,110,
                46,79,112,101,110,84,121,112,101,-128,
                100,26,-111,-23,-22,-34,60,2,0,3,
                76,0,9,99,108,97,115,115,78,97,
                109,101,113,0,126,0,6,76,0,11,
                100,101,115,99,114,105,112,116,105,111,
                110,113,0,126,0,6,76,0,8,116,
                121,112,101,78,97,109,101,113,0,126,
                0,6,120,112,113,0,126,0,11,113,
                0,126,0,11,113,0,126,0,11
            };
            map.put("stringPar",bytes);
        }
       // boolAttr:  javax.management.openmbean.OpenMBeanAttributeInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,65,116,116,114,105,98,
                117,116,101,73,110,102,111,83,117,112,
                112,111,114,116,-68,116,45,45,-28,-120,
                -79,7,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,65,116,116,114,105,98,117,116,
                101,73,110,102,111,119,-8,41,59,106,
                41,68,-40,2,0,4,90,0,2,105,
                115,90,0,6,105,115,82,101,97,100,
                90,0,7,105,115,87,114,105,116,101,
                76,0,13,97,116,116,114,105,98,117,
                116,101,84,121,112,101,116,0,18,76,
                106,97,118,97,47,108,97,110,103,47,
                83,116,114,105,110,103,59,120,114,0,
                33,106,97,118,97,120,46,109,97,110,
                97,103,101,109,101,110,116,46,77,66,
                101,97,110,70,101,97,116,117,114,101,
                73,110,102,111,54,-37,117,-36,-62,-63,
                85,33,2,0,2,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,4,110,97,109,
                101,113,0,126,0,6,120,112,116,0,
                5,100,101,115,99,114,116,0,8,98,
                111,111,108,65,116,116,114,0,1,0,
                116,0,17,106,97,118,97,46,108,97,
                110,103,46,66,111,111,108,101,97,110,
                115,114,0,17,106,97,118,97,46,108,
                97,110,103,46,66,111,111,108,101,97,
                110,-51,32,114,-128,-43,-100,-6,-18,2,
                0,1,90,0,5,118,97,108,117,101,
                120,112,1,112,112,112,115,114,0,37,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,111,112,101,
                110,109,98,101,97,110,46,83,105,109,
                112,108,101,84,121,112,101,30,-65,79,
                -8,-36,101,120,39,2,0,0,120,114,
                0,35,106,97,118,97,120,46,109,97,
                110,97,103,101,109,101,110,116,46,111,
                112,101,110,109,98,101,97,110,46,79,
                112,101,110,84,121,112,101,-128,100,26,
                -111,-23,-22,-34,60,2,0,3,76,0,
                9,99,108,97,115,115,78,97,109,101,
                113,0,126,0,6,76,0,11,100,101,
                115,99,114,105,112,116,105,111,110,113,
                0,126,0,6,76,0,8,116,121,112,
                101,78,97,109,101,113,0,126,0,6,
                120,112,113,0,126,0,11,113,0,126,
                0,11,113,0,126,0,11
            };
            map.put("boolAttr",bytes);
        }
       // floatPar:  javax.management.openmbean.OpenMBeanParameterInfoSupport
       //
       {
            final byte[] bytes = new byte[] {
                -84,-19,0,5,115,114,0,56,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,111,112,101,110,109,
                98,101,97,110,46,79,112,101,110,77,
                66,101,97,110,80,97,114,97,109,101,
                116,101,114,73,110,102,111,83,117,112,
                112,111,114,116,-101,-104,14,124,111,-85,
                -71,-114,2,0,5,76,0,12,100,101,
                102,97,117,108,116,86,97,108,117,101,
                116,0,18,76,106,97,118,97,47,108,
                97,110,103,47,79,98,106,101,99,116,
                59,76,0,11,108,101,103,97,108,86,
                97,108,117,101,115,116,0,15,76,106,
                97,118,97,47,117,116,105,108,47,83,
                101,116,59,76,0,8,109,97,120,86,
                97,108,117,101,116,0,22,76,106,97,
                118,97,47,108,97,110,103,47,67,111,
                109,112,97,114,97,98,108,101,59,76,
                0,8,109,105,110,86,97,108,117,101,
                113,0,126,0,3,76,0,8,111,112,
                101,110,84,121,112,101,116,0,37,76,
                106,97,118,97,120,47,109,97,110,97,
                103,101,109,101,110,116,47,111,112,101,
                110,109,98,101,97,110,47,79,112,101,
                110,84,121,112,101,59,120,114,0,35,
                106,97,118,97,120,46,109,97,110,97,
                103,101,109,101,110,116,46,77,66,101,
                97,110,80,97,114,97,109,101,116,101,
                114,73,110,102,111,103,37,-11,-84,-39,
                123,54,2,2,0,1,76,0,4,116,
                121,112,101,116,0,18,76,106,97,118,
                97,47,108,97,110,103,47,83,116,114,
                105,110,103,59,120,114,0,33,106,97,
                118,97,120,46,109,97,110,97,103,101,
                109,101,110,116,46,77,66,101,97,110,
                70,101,97,116,117,114,101,73,110,102,
                111,54,-37,117,-36,-62,-63,85,33,2,
                0,2,76,0,11,100,101,115,99,114,
                105,112,116,105,111,110,113,0,126,0,
                6,76,0,4,110,97,109,101,113,0,
                126,0,6,120,112,116,0,5,100,101,
                115,99,114,116,0,8,102,108,111,97,
                116,80,97,114,116,0,15,106,97,118,
                97,46,108,97,110,103,46,70,108,111,
                97,116,115,114,0,15,106,97,118,97,
                46,108,97,110,103,46,70,108,111,97,
                116,-38,-19,-55,-94,-37,60,-16,-20,2,
                0,1,70,0,5,118,97,108,117,101,
                120,114,0,16,106,97,118,97,46,108,
                97,110,103,46,78,117,109,98,101,114,
                -122,-84,-107,29,11,-108,-32,-117,2,0,
                0,120,112,63,-128,0,0,112,115,113,
                0,126,0,12,64,0,0,0,115,113,
                0,126,0,12,0,0,0,0,115,114,
                0,37,106,97,118,97,120,46,109,97,
                110,97,103,101,109,101,110,116,46,111,
                112,101,110,109,98,101,97,110,46,83,
                105,109,112,108,101,84,121,112,101,30,
                -65,79,-8,-36,101,120,39,2,0,0,
                120,114,0,35,106,97,118,97,120,46,
                109,97,110,97,103,101,109,101,110,116,
                46,111,112,101,110,109,98,101,97,110,
                46,79,112,101,110,84,121,112,101,-128,
                100,26,-111,-23,-22,-34,60,2,0,3,
                76,0,9,99,108,97,115,115,78,97,
                109,101,113,0,126,0,6,76,0,11,
                100,101,115,99,114,105,112,116,105,111,
                110,113,0,126,0,6,76,0,8,116,
                121,112,101,78,97,109,101,113,0,126,
                0,6,120,112,113,0,126,0,11,113,
                0,126,0,11,113,0,126,0,11
            };
            map.put("floatPar",bytes);
        }

    }
        
    /** 
     * Deserialize a byte array into an object.
     * @param bytes The bytes to deserialize.
     * @return The deserialized object.
     * @throws IOException if the object cannot be deserialized.
     * @throws ClassNotFoundException if the class of the serialized object
     *         cannot be loaded.
     **/
    public static Object deserialize(byte[] bytes) throws IOException, 
            ClassNotFoundException {
        final ByteArrayInputStream bin = new ByteArrayInputStream(bytes); 
        final ObjectInputStream istr = new ObjectInputStream(bin);
        return istr.readObject();
    }

    /**
     * The set of keys for objects registered in this serialized data store.
     * For each of these keys we have a serialized object of type 
     * MBeanFeatureInfo.
     * @return The set of keys corresponding to registered objects.
     **/
    public static Set<String> keySet() {
	return map.keySet();
    }
        
    /**
     * Retrieves and deserializes the object stored at the given key.
     * @return The deserialized object.
     * @throws IOException if the object cannot be deserialized.
     * @throws ClassNotFoundException if the class of the serialized object
     *         cannot be loaded.
     **/
    public static MBeanFeatureInfo get(String name) 
    throws IOException, ClassNotFoundException {
        final byte[] bytes = map.get(name);
        final Object obj = deserialize(bytes);
        return (MBeanFeatureInfo)obj;
    }

    /**
     * Version of the JVM that was used to generate the serialized data.
     **/
    public static final String SERIALIZER_VM_VERSION =
            "1.5.0_05";
    
    /**
     * Vendor of the JVM that was used to generate the serialized data.
     **/
    public static final String SERIALIZER_VM_VENDOR=
            "Sun Microsystems Inc.";

}
