package CType::BitField;

use 5.6.0;
use strict;
use warnings;

use CType;

our @ISA = qw/CType/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $type = shift;
    my $width = shift;

    my $self = {type => $type,
                width => $width->compute,
               };
    bless $self, $class;
    return $self;
  }

sub width
  {
    my $self = shift;
    return $self->{width};
  }

sub alignment
  {
    my $self = shift;
    return $self->{type}->alignment;
  }

sub layout
  {
  }

sub dump_c
  {
    my $self = shift;
    my $skip_cpp = shift;
    my $name = shift;

    my $str = "";

    $str .= $self->dump_location($skip_cpp);

    if ($self->{type}->capture_declarator)
      {
        $str .= $self->{type}->dump_c($skip_cpp, $name);
      }
    else
      {
        $str .= $self->{type}->dump_c($skip_cpp) . ' ' . $name;
      }

    $str .= ' : ';
    $str .= $self->{width};
    return $str;
  }

sub capture_declarator
  {
    return 1;
  }

sub describe
  {
    my $self = shift;

    my $width = $self->{width} . "-bit";
    my $type = $self->{type}->describe;

    return "$width bitfield of $type";
  }

sub get_refs
  {
    my $self = shift;
    return $self->{type}->get_refs;
  }

sub _check_interface
  {
    my $self = shift;
    my $other = shift;

    return 'both' unless $other->isa('CType::BitField');

    my @ret;

    unless ($self->width == $other->width)
      {
        push @ret, 'abi';
      }

    push @ret, $self->{type}->check_interface($other->{type});

    return @ret;
  }

1;
