#-------------------------------------------------------------------------------
#
#     This file is part of the Code_Saturne User Interface, element of the
#     Code_Saturne CFD tool.
#
#     Copyright (C) 1998-2008 EDF S.A., France
#
#     contact: saturne-support@edf.fr
#
#     The Code_Saturne User Interface is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     as published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.
#
#     The Code_Saturne User Interface is distributed in the hope that it will be
#     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
#     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with the Code_Saturne Kernel; if not, write to the
#     Free Software Foundation, Inc.,
#     51 Franklin St, Fifth Floor,
#     Boston, MA  02110-1301  USA
#
#-------------------------------------------------------------------------------

"""
This is the ics setup script.

'python setup.py install', or
'python setup.py install --prefix MY_INSTALL_PATH', or
'python setup.py --help' for more options
"""

import sys
if not hasattr(sys, 'version_info') or sys.version_info < (2, 5, 0, 'final'):
    raise SystemExit, "Graphical users interface of Code_Saturne requires python 2.5 or later."

from Base.Common import VERSION

from distutils.core import setup

setup(name='ics',
      version=VERSION,
      url='www.code-saturne.org',
      description='Graphical user interface of Code_Saturne CFD code',
      license='GNU GPL',
      maintainer='Code_Saturne team',
      maintainer_email='saturne-support@edf.fr',
      scripts=['ics'],
      packages=['Base', 'Pages'],
      )

