/*
        IcuKrell 2.0.0-pre0.1 - drJeckyll <drJeckyll@hotmail.com>
*/

#include "icukrell.h"

static GkrellmMonitor	*icukrell_plugin;

static GkrellmPanel	*panel, 
		*online_panel;

static GkrellmDecal	*decal_text_status, 
		*decal_text_msg_count, 
		*decal_online_users, 
		*decal_pic, 
		*decal_online_users_panel;

static gchar	message_status[100] = ICU_DOWN;
static gchar	message_msg_count[100] = ICU_NO_MSGS;
static gchar	online_users[100] = NO_USERS;
static gint	style_id;

static GtkWidget *gkrellm_vbox;

int tmp_online_panel_users = 1;
gchar scrolled_text[1000];
int scroll_width = 0;
int scroll_pos   = 0;

int counter = -1;

int detected_ppp = 0;

void destroy_online_panel();
void save_message_status();
void get_message_status();

static void panel_button_press(GtkWidget *widget, GdkEventButton *ev, gpointer data)
{
    switch (ev->button)
    {
	case 1:
	    if ((ev->type == GDK_2BUTTON_PRESS) && !icukrell_running) start_gnomeicu_func();
	    else
	    {
		if (!strcmp(message_msg_count, ICU_NO_MSGS))
		    do_action("showhide", NULL);
		else
		    do_action("readevent", NULL);
	    }
	    break;
	case 2:
	    if (icukrell_running) get_online_users(ev);
	    break;
	case 3:
	    options_menu(ev);
	    break;
    }
}

static void misc_online_panel_button_press(GtkWidget *widget, GdkEventButton *ev, gpointer data)
{
    switch (ev->button)
    {
	case 1:
	    break;
	case 2:
	    gkrellm_open_config_window(icukrell_plugin);
	    break;
	case 3:
	    break;
    }
}

static gint panel_expose_event(GtkWidget *widget, GdkEventExpose *ev)
{
    gdk_draw_pixmap(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y, ev->area.width, ev->area.height);
    return FALSE;
}

static gint online_panel_expose_event(GtkWidget *widget, GdkEventExpose *ev)
{
    gdk_draw_pixmap(widget->window, widget->style->fg_gc[GTK_WIDGET_STATE (widget)], online_panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y, ev->area.width, ev->area.height);
    return FALSE;
}

static void misc_check_running()
{
#ifdef BIG_TEST_MODE
    fprintf(stderr, "start misc_check_running\n");
#endif
    if (tmp_icukrell_running != icukrell_running)
    {
	tmp_icukrell_running = icukrell_running;
	//destroy_plugin();
	
	do_action("hide", NULL);
    }
#ifdef BIG_TEST_MODE
    fprintf(stderr, "start end_check_running\n");
#endif
}

static void update_status_pic()
{
    gint x, y;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

#ifdef BIG_TEST_MODE
    fprintf(stderr, "update!\n");
#endif

    if (!icukrell_running)
    {
	strcpy(online_users, NO_USERS);
	decal_online_users->x_off = 1;
        gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);
        decal_online_users->x_off = 0;
        gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);

	gkrellm_make_decal_invisible(panel, decal_online_users);

        gkrellm_make_decal_invisible(panel, decal_pic);
	gkrellm_make_decal_invisible(panel, decal_online_users);
	gkrellm_make_decal_invisible(panel, decal_text_msg_count);
		
	if (tmp_online_panel_users)
	{
#ifdef TEST_MODE
	    fprintf(stderr, "destroy on update\n");
#endif
	    tmp_online_panel_users = 0;
	    //destroy_plugin();
	    gkrellm_panel_hide(online_panel);
	}
	
	detected_ppp = 0;
    } else
    {
        pixmap = offline_pixmap;
        mask = offline_bitmap;

        if (!strcmp(message_status, ICU_OFFLINE))
        {
            pixmap = offline_pixmap;
            mask = offline_bitmap;
        }
        if (!strcmp(message_status, ICU_ONLINE))
        {
            pixmap = online_pixmap;
            mask = online_bitmap;
        }
        if (!strcmp(message_status, ICU_INVISIBLE))
        {
            pixmap = inv_pixmap;
            mask = inv_bitmap;
        }
        if (!strcmp(message_status, ICU_NA) || !strcmp(message_status, ICU_NA_99A))
        {
            pixmap = na_pixmap;
            mask = na_bitmap;
        }
        if (!strcmp(message_status, ICU_FREE_CHAT))
        {
            pixmap = chat_pixmap;
            mask = chat_bitmap;
        }
        if (!strcmp(message_status, ICU_OCCUPIED) || !strcmp(message_status, ICU_OCCUPIED_MAC))
        {
            pixmap = occ_pixmap;
            mask = occ_bitmap;
        }
	if (!strcmp(message_status, ICU_AWAY))
        {
            pixmap = away_pixmap;
            mask = away_bitmap;
        }
        if (!strcmp(message_status, ICU_DND))
        {
            pixmap = dnd_pixmap;
            mask = dnd_bitmap;
        }

        x = gkrellm_chart_width() - 20;
        y = decal_text_status->y + 3;
        gkrellm_make_decal_invisible(panel, decal_pic);
        decal_pic = gkrellm_create_decal_pixmap(panel, pixmap, mask, 1, NULL, x, y);
        gkrellm_draw_decal_pixmap(panel, decal_pic, 0);
        gkrellm_make_decal_visible(panel, decal_pic);

	if (!strcmp(message_status, ICU_OFFLINE))
	{
	    strcpy(online_users, NO_USERS);
	    decal_online_users->x_off = 1;
            gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);
            decal_online_users->x_off = 0;
            gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);

#ifdef TEST_MODE
	    fprintf(stderr, "HIDE ONLINE PANEL\n");
#endif
	    gkrellm_make_decal_invisible(panel, decal_online_users);
	    gkrellm_panel_hide(online_panel);
		    
	    if (tmp_online_panel_users)
	    {
#ifdef TEST_MODE
	    fprintf(stderr, "destroy on update 2\n");
#endif
		tmp_online_panel_users = 0;
		//destroy_plugin();
	    }
	} else
	{
	    gkrellm_make_decal_visible(panel, decal_online_users);
	    gkrellm_panel_show(online_panel);
	    
	    if (!tmp_online_panel_users)
	    {
#ifdef TEST_MODE
	    fprintf(stderr, "destroy on update 3\n");
#endif
		tmp_online_panel_users = 1;
		//destroy_plugin();
	    }
	}
	
	misc_check_running();
	
	gkrellm_make_decal_visible(panel, decal_text_msg_count);
    }
}

void make_scroll()
{
    gchar full_buffer[1000];
    gchar *nick, *uin, *status;
    gchar tmp[200];

    do_action("onlinelist", full_buffer);
    scrolled_text[0] = 0;

    nick = strtok(full_buffer, "\t");
    uin = strtok(NULL, "\t");
    status = strtok(NULL, "\t");

    sprintf(tmp, "%s [%s]    ", nick, status);
    strcat(scrolled_text, tmp);

    while ((nick = strtok(NULL, "\t")) != NULL)
    {
	uin = strtok(NULL, "\t");
	status = strtok(NULL, "\t");

	sprintf(tmp, "%s [%s]    ", nick, status);
	strcat(scrolled_text, tmp);
    }

    if ((!strcmp(online_users, NO_USERS)) || (!strcmp(scrolled_text, "(null) [(null)]    ")))
	strcpy(scrolled_text, NO_USERS_SCROLL);

    scroll_width = gdk_string_width(online_panel->textstyle->font, scrolled_text);
}

static void update_plugin()
{
        gchar new_message_status[100] = ICU_DOWN;
        gchar new_message_msg_count[100];
	gchar new_theme_name[255];
	gchar new_online_users[100] = NO_USERS;
        unsigned long u;
        gchar *buffer;
        gchar c = 1;
        gint x, y;
        GdkPixmap *pixmap;
        GdkBitmap *mask;
	int socket_fd;

#ifdef BIG_TEST_MODE
	fprintf(stderr, "start update_plugin\n");
#endif
	// detect ppp line
	if (auto_detect_ppp && icukrell_running)
	{
	    if (detect_ppp())
	    {
		if (!detected_ppp)
		{
		    detected_ppp = 1;
		    get_message_status();
		}
	    } else
	    {
		if (detected_ppp)
		{
		    detected_ppp = 0;
		    save_message_status();
		    
		    do_action("status offline", NULL);
		}
	    }
	}

	// this make me crazy !
	if (icukrell_blink_speed == 0) icukrell_blink_speed = 2;
	if (icukrell_scroll_speed == 0) icukrell_scroll_speed = 2;

	if ((online_users_panel) && (tmp_online_panel_users))
	{
	    // make some scroll
	    if (online_panel_scroll_direction)
	    {
		decal_online_users_panel->x_off += icukrell_scroll_speed;
		
		if (decal_online_users_panel->x_off > gkrellm_chart_width())
		{
		    make_scroll();
		    decal_online_users_panel->x_off = -scroll_width;
		}
	    }
	    else
	    {
		decal_online_users_panel->x_off -= icukrell_scroll_speed;
		
		if (decal_online_users_panel->x_off < -scroll_width)
		{
		    make_scroll();
		    decal_online_users_panel->x_off = gkrellm_chart_width();
		}
	    }
	    gkrellm_draw_decal_text(online_panel, decal_online_users_panel, scrolled_text, decal_online_users_panel->x_off);
	    gkrellm_draw_panel_layers(online_panel);
	}

        if ((GK.timer_ticks % icukrell_blink_speed) == 0)
        {
                if (!access(addr.sun_path, R_OK) != 0)
                {
                        socket_fd = socket(AF_UNIX, SOCK_STREAM, 0);

                        if(socket_fd >= 0)
                        {
                                if (connect(socket_fd, (struct sockaddr *)&addr, sizeof(addr.sun_family) + strlen(addr.sun_path) + 1) == 0)
                                {
                                        strcpy(new_message_status, "PRB");

                                        buffer = g_malloc0(8192);

                                        strcat(buffer, "icuask");
                                        strcat(buffer, " ");
                                        c = 9;

                                        u = htonl(strlen(buffer) + 1);

                                        write(socket_fd, &c, 1);
                                        write(socket_fd, &u, sizeof(unsigned long));
                                        write(socket_fd, buffer, strlen(buffer)+1);

                                        g_free(buffer);

                                        read(socket_fd, &u, sizeof(unsigned long));
                                        u = g_htonl(u);
                                        if (u < 16384)
                                        {
                                                buffer = g_malloc0(u + 1);
                                                read(socket_fd, buffer, u);

                                                strcpy(new_message_status, strtok(buffer, " "));
                                                strcpy(new_message_msg_count, strtok(NULL, " "));
						sprintf(new_online_users, "%s User", strtok(NULL, " "));
						if (strcmp(new_online_users, "1 User"))
						    strcat(new_online_users, "s");
						strcpy(new_theme_name, strtok(NULL, "\n"));

                                                if (!strcmp(new_message_msg_count, "0"))
                                                        sprintf(new_message_msg_count, "%s", ICU_NO_MSGS);
                                                else
							sprintf(new_message_msg_count, "%s", new_message_msg_count);

						if (strcmp(new_theme_name, icukrell_theme_name))
						{
							g_free(icukrell_theme_name);
							icukrell_theme_name = g_strdup(new_theme_name);
							if (init_pixmaps()) ;
							update_status_pic();
#ifdef BIG_TEST_MODE
							fprintf(stderr, "[%s]\n", new_theme_name);
#endif
						}

                                                g_free(buffer);

						icukrell_running = TRUE;
                                        }
                                } else icukrell_running = FALSE;
                        }
			close(socket_fd);
                } else icukrell_running = FALSE;

		misc_check_running();

                if (strcmp(message_status, new_message_status))
                {
			strcpy(message_status,  new_message_status);
			decal_text_status->x_off = 1;
                        gkrellm_draw_decal_text(panel, decal_text_status, message_status, decal_text_status->x_off);
                        decal_text_status->x_off = 0;
                        gkrellm_draw_decal_text(panel, decal_text_status, message_status, decal_text_status->x_off);

                        if (!icukrell_running)
                                gkrellm_make_decal_invisible(panel, decal_text_msg_count);

                        update_status_pic();
			
			if (icukrell_running && strcmp(message_status, ICU_OFFLINE)) save_message_status();
                }
		
		if (strcmp(online_users, new_online_users))
		{
			strcpy(online_users, new_online_users);
			decal_online_users->x_off = 1;
                        gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);
                        decal_online_users->x_off = 0;
                        gkrellm_draw_decal_text(panel, decal_online_users, online_users, decal_online_users->x_off);

                        if (!icukrell_running) gkrellm_make_decal_invisible(panel, decal_online_users);
		}

                if (strcmp(message_msg_count, new_message_msg_count))
                {
			strcpy(message_msg_count,  new_message_msg_count);
			decal_text_msg_count->x_off = 1;
                        gkrellm_draw_decal_text(panel, decal_text_msg_count, message_msg_count, decal_text_msg_count->x_off);
                        decal_text_msg_count->x_off = 0;
                        gkrellm_draw_decal_text(panel, decal_text_msg_count, message_msg_count, decal_text_msg_count->x_off);

                        if (icukrell_running)
                        {
                                if (strcmp(new_message_msg_count, ICU_NO_MSGS))
                                {
                                        pixmap = message_pixmap;
                                        mask = message_bitmap;
                                        x = gkrellm_chart_width() - 20;
                                        y = decal_text_status->y + 3;
                                        gkrellm_make_decal_invisible(panel, decal_pic);
                                        decal_pic = gkrellm_create_decal_pixmap(panel, pixmap, mask, 1, NULL, x, y);
                                        gkrellm_make_decal_visible(panel, decal_pic);
                                        gkrellm_draw_decal_pixmap(panel, decal_pic, 0);
                                } else update_status_pic();
                        }
                }
		
		if (strcmp(message_msg_count, ICU_NO_MSGS) && icukrell_running)
		{
			if ((GK.timer_ticks % (icukrell_blink_speed * 2)) == 0)
			{
				gkrellm_make_decal_visible(panel, decal_pic);
			} else
			{
				gkrellm_make_decal_invisible(panel, decal_pic);
			}
				
		}

                gkrellm_draw_panel_layers(panel);
        }

	if (first_start)
	{
	    if (!icukrell_running && icukrell_auto_start)
	    {
		start_gnomeicu_func();

		if (icukrell_auto_hide) counter = ICUKRELL_TIMEOUT_BEFORE_HIDE;
	    } else
	    if (icukrell_auto_hide) do_action("hide", NULL);

	    first_start = FALSE;
	}
	
	if (counter >= 0)
	{
	    if ((counter == 0) && icukrell_auto_hide)
	    {
		do_action("hide", NULL);
	    }

	    counter--;
	}
	
#ifdef BIG_TEST_MODE
	fprintf(stderr, "end update_plugin\n");
#endif
}

static void create_online_panel(gint first_create, GkrellmTextstyle *ts, GkrellmTextstyle *ts_alt, GkrellmStyle *style, GtkWidget *vbox)
{
#ifdef TEST_MODE
    fprintf(stderr, "start create_online_panel\n");
#endif
    online_panel = gkrellm_panel_new0();
    online_panel->textstyle = ts_alt;
    
    decal_online_users_panel = gkrellm_create_decal_text(online_panel, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", ts_alt, style, 2, 4, 0);
    online_panel->label->h_panel += 2;
    //gkrellm_bg_meter_piximage(style_id)
    gkrellm_panel_configure(online_panel, NULL, style);
    gkrellm_panel_create(vbox, icukrell_plugin, online_panel);
    //gkrellm_monitor_height_adjust(online_panel->h);
    gkrellm_draw_decal_text(online_panel, decal_online_users_panel, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 1);

    //if (first_create)
    {
	gtk_signal_connect(GTK_OBJECT (online_panel->drawing_area), "expose_event", (GtkSignalFunc) online_panel_expose_event, NULL);
	gtk_signal_connect(GTK_OBJECT (online_panel->drawing_area), "button_press_event", (GtkSignalFunc) misc_online_panel_button_press, NULL);
    }

#ifdef TEST_MODE
    fprintf(stderr, "end create_online_panel\n");
#endif
}

static void create_plugin(GtkWidget *vbox, gint first_create)
{
    GkrellmStyle *style;
    GkrellmTextstyle *ts, *ts_alt;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    gint x, y;

#ifdef TEST_MODE
    fprintf(stderr, "start create_plugin\n");
#endif
    gkrellm_vbox = vbox;

    if (first_create)
    {
        panel = gkrellm_panel_new0();
    } else
    {
        gkrellm_destroy_krell_list(panel);
        gkrellm_destroy_decal_list(panel);
    }
    style = gkrellm_meter_style(style_id);

    ts = gkrellm_meter_textstyle(style_id);
    ts_alt = gkrellm_meter_alt_textstyle(style_id);

    panel->textstyle = ts;

    decal_text_status = gkrellm_create_decal_text(panel, message_status, ts_alt, style, -1, 4, -1);
    y = decal_text_status->y + decal_text_status->h + 4;
    decal_text_msg_count = gkrellm_create_decal_text(panel, message_msg_count, ts, style, gkrellm_chart_width() - 15, y - 5, 0);
    //decal_online_users = gkrellm_create_decal_text(panel, online_users, ts_alt, style, 2, y, 0);
    decal_online_users = gkrellm_create_decal_text(panel, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", ts_alt, style, 2, y, 0);

    pixmap = offline_pixmap;
    mask = offline_bitmap;
    x = gkrellm_chart_width() - 20;
    y = decal_text_status->y + 2;
    decal_pic = gkrellm_create_decal_pixmap(panel, pixmap, mask, 1, NULL, x, y);

    gkrellm_panel_configure(panel, NULL, style);

    panel->label->h_panel += 2;

    gkrellm_panel_create(vbox, icukrell_plugin, panel); //gkrellm_bg_meter_image(style_id)

    //gkrellm_monitor_height_adjust(panel->h);

    gkrellm_draw_decal_text(panel, decal_text_status, message_status, 1);
    gkrellm_draw_decal_text(panel, decal_online_users, online_users, 1);
    gkrellm_make_decal_invisible(panel, decal_text_msg_count);
    gkrellm_make_decal_invisible(panel, decal_online_users);
    gkrellm_draw_decal_pixmap(panel, decal_pic, 0);
    gkrellm_make_decal_invisible(panel, decal_pic);

    //if (online_panel) destroy_online_panel();

    create_online_panel(first_create, ts, ts_alt, style, vbox);
    if ((online_users_panel) && (tmp_online_panel_users))
    {
	make_scroll();
	    
	if (online_panel_scroll_direction)
	    decal_online_users_panel->x_off = -scroll_width;
	else
	    decal_online_users_panel->x_off = gkrellm_chart_width();
    }

    if (first_create)
    {
	gtk_signal_connect(GTK_OBJECT (panel->drawing_area), "expose_event", (GtkSignalFunc) panel_expose_event, NULL);
	gtk_signal_connect(GTK_OBJECT (panel->drawing_area), "button_press_event", (GtkSignalFunc) panel_button_press, NULL);
    }

    update_status_pic();

#ifdef TEST_MODE
    fprintf(stderr, "end create_plugin\n");
#endif
}

void destroy_online_panel()
{
#ifdef TEST_MODE
    fprintf(stderr, "start destroy_online_panel\n");
#endif
    if (online_panel != NULL)
    {
	gkrellm_monitor_height_adjust(- online_panel->h);
	gkrellm_destroy_decal_list(online_panel);
	gkrellm_panel_destroy(online_panel);
	g_free(online_panel);
    }
    online_panel = NULL;
#ifdef TEST_MODE
    fprintf(stderr, "end destroy_online_panel\n");
#endif
}

void destroy_plugin()
{
#ifdef TEST_MODE
    fprintf(stderr, "start destroy_plugin\n");
#endif
    if (panel != NULL)
    {
	gkrellm_monitor_height_adjust(- panel->h);
	gkrellm_destroy_decal_list(panel);
	gkrellm_panel_destroy(panel);
	g_free(panel);
    }
    panel = NULL;

    destroy_online_panel();
    
    create_plugin(gkrellm_vbox, 1);
    gkrellm_pack_side_frames();
#ifdef TEST_MODE
    fprintf(stderr, "end destroy_plugin\n");
#endif
}

void save_message_status()
{
    FILE *f;
    char fname[100];
    
    sprintf(fname, "%s/.gkrellm/data/icukrell_last_status", g_get_home_dir());
    if ((f = fopen(fname, "w")) != NULL)
    {
	fprintf(f, "%s", message_status);
	
	fclose(f);
    }
}

void get_message_status()
{
    FILE *f;
    char fname[100];
    char buf[100];

    sprintf(fname, "%s/.gkrellm/data/icukrell_last_status", g_get_home_dir());
    if ((f = fopen(fname, "r")) != NULL)
    {
	fgets(buf, sizeof(buf), f);

	if (!strncmp(buf, "Offline", 7)) do_action("status offline", NULL);
	else
	if (!strncmp(buf, "Online", 6)) do_action("status online", NULL);
	else
	if (!strncmp(buf, "Invisible", 9)) do_action("status invisible", NULL);
	else
	if (!strncmp(buf, "N/A", 3)) do_action("status na", NULL);
	else
	if (!strncmp(buf, "Free4Chat", 9)) do_action("status freechat", NULL);
	else
	if (!strncmp(buf, "Occupied", 8)) do_action("status occupied", NULL);
	else
	if (!strncmp(buf, "Away", 4)) do_action("status away", NULL);
	else
	if (!strncmp(buf, "DND", 3)) do_action("status dnd", NULL);

	fclose(f);
    }
}

void quit_plugin_func()
{
    if (icukrell_auto_hide && icukrell_running)
	do_action("show", NULL);
}
      

static GkrellmMonitor plugin_monitor =
{
    CONFIG_NAME,                    /* Name, for config tab.             */
    0,                              /* Id,  0 if a plugin                */
    create_plugin,                  /* The create function               */
    update_plugin,                  /* The update function               */
    create_icukrell_config,         /* The config tab create function    */
    icukrell_apply_config,          /* Apply the config function         */
    icukrell_save_config,           /* Save user config                  */
    icukrell_load_config,           /* Load user config                  */
    CONFIG_KEYWORD,                 /* config keyword                    */
    NULL,                           /* Undefined 2                       */
    NULL,                           /* Undefined 1                       */
    NULL,                           /* private                           */
    MON_MAIL,                       /* Insert plugin before this monitor */
    NULL,                           /* Handle if a plugin, filled in by GkrellM */
    NULL                            /* path if a plugin, filled in by GKrellM   */
};

GkrellmMonitor *gkrellm_init_plugin()
{
    first_start = TRUE;

    icukrell_plugin = &plugin_monitor;

    running_factory = options_menu_factory(1);
    not_running_factory = options_menu_factory(0);

    icukrell_theme_name = g_strdup("Default"); /* to be freeable on change */
    sprintf(addr.sun_path, "/tmp/.gnomeicu-%s/ctl", g_get_user_name());
    addr.sun_family = AF_UNIX;
    if (init_pixmaps()) ;

    g_atexit(quit_plugin_func);
	
    style_id = gkrellm_add_meter_style(&plugin_monitor, STYLE_NAME);

    return &plugin_monitor;
}
