/*
#   avcodecdecode.h: decodes wma file format for xlplayer
#   Copyright (C) 2007 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "../config.h"

#ifdef HAVE_AVCODEC
#ifdef HAVE_AVFORMAT

#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>
#include "xlplayer.h"

struct avcodecdecode_vars
   {
   AVCodec *codec;
   AVPacket pkt;
   AVCodecContext *c;
   AVFormatContext *ic;
   int resample;
   int stream;
   uint8_t *outbuf;
   float *floatsamples;
   };

int avcodecdecode_reg(struct xlplayer *xlplayer);
void avformatinfo(char *pathname);

#endif /* HAVE_AVFORMAT */
#endif /* HAVE_AVCODEC */
