/*
#   kvpparse.c: the mixer and server command parsing mechanism used by IDJC.
#   Copyright (C) 2005-2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#define _GNU_SOURCE
#include <stdlib.h>
#include <string.h>
#include "kvpparse.h"

int kvp_parse(struct kvpdict *kvpdict, FILE *fp)
   {
   char *buffer = NULL, *key, *value;
   int qty = 0;
   size_t n;
 
   while (getline(&buffer, &n, fp), n && strcmp(buffer, "end\n"))
      {
      if (feof(fp))
         {
         qty = 0;	/* this will ultimately cause the program to terminate */
	 break;
	 }
      /* the following function is fed a key value pair e.g. key=value */
      value = kvp_extract_value((key = buffer)); /* key is truncated at the = */
      /* value = a pointer to a copy of the value part after the '=' allocated on the heap */
      qty += dict_apply_to_target(kvpdict, key, value);
         /* value becomes pointed to by a pointer, pointed to in kvpdict */
      }

   if (buffer)
      free(buffer);
   else
      fprintf(stderr, "getline failed to allocate a buffer in function kvp_parse\n");
   return qty;		/* the number of keys matched */
   }
