#   IDJCservdialog.py: Server dialogs for IDJC
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk, gtk, pango
from idjc_config import *

# A mutually exclusive list of dialogs so that only one can be on screen at a time
# The dialogs below can call the hide method to remove any other dialogs
class dialog_group:
   def __init__(self):
      self.dialist = []
   def add(self, newdialog):
      self.dialist.append(newdialog)
   def hide(self, apartfrom = None):
      for each in self.dialist:
         if each is not apartfrom:
            each.hide()

# Used to show a dialog related to the failure of the server connection
class error_notification_dialog(gtk.Dialog):
   def window_attn(self, widget, event):
      if event.new_window_state | gtk.gdk.WINDOW_STATE_ICONIFIED:
         widget.set_urgency_hint(True)
      else:
         widget.set_urgency_hint(False)
   
   def respond(self, dialog, response):
      if response == gtk.RESPONSE_CLOSE or response == gtk.RESPONSE_DELETE_EVENT:
         dialog.hide()
   
   def present(self):
      self.dial_group.hide(self)
      gtk.Dialog.present(self)
            
   def __init__(self, dial_group = None, window_group = None, window_title = "", additional_text = None):
      gtk.Dialog.__init__(self, window_title, None, gtk.DIALOG_DESTROY_WITH_PARENT, (gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE))
      if window_group is not None:
         window_group.add_window(self)
      self.set_icon_from_file(pkgdatadir + "icon" + gfext)
      self.set_resizable(False)
      self.connect("close", self.respond)
      self.connect("response", self.respond)
      self.connect("window-state-event", self.window_attn)
      
      hbox = gtk.HBox(False, 20)
      hbox.set_border_width(20)
      self.vbox.pack_start(hbox, True, True, 0)
      hbox.show()
      image = gtk.Image()
      image.set_from_stock(gtk.STOCK_DIALOG_ERROR, gtk.ICON_SIZE_DIALOG)
      hbox.pack_start(image, True, True, 0)
      image.show()
      vbox = gtk.VBox()
      vbox.set_spacing(8)
      hbox.pack_start(vbox, True, True, 0)
      vbox.show()
      
      if additional_text is not None:
         if type(additional_text) is str:
            additional_text = additional_text.splitlines()
         for each in additional_text:
            label = gtk.Label()
            attrlist = pango.AttrList()
            attrlist.insert(pango.AttrSize(12500, 0, len(each)))
            label.set_attributes(attrlist)
            label.set_text(each)
            vbox.add(label)
            label.show()
      if dial_group is not None:
         dial_group.add(self)
      self.dial_group = dial_group
      # Dialog is not shown upon creation, but rather is (re)shown when needed.


# Used to show when autodisconnection is imminent with the option to cancel
class autodisconnection_notification_dialog(gtk.Dialog):
   def window_attn(self, widget, event):
      if event.new_window_state | gtk.gdk.WINDOW_STATE_ICONIFIED:
         widget.set_urgency_hint(True)
      else:
         widget.set_urgency_hint(False)
   
   def respond(self, dialog, response, actionok = None, actioncancel = None):
      if response == gtk.RESPONSE_OK or response == gtk.RESPONSE_DELETE_EVENT:
         if actionok is not None:
            actionok()
      if response == gtk.RESPONSE_CANCEL:
         if actioncancel is not None:
            actioncancel()
      dialog.hide()

   def present(self):
      self.dial_group.hide(self)
      gtk.Dialog.present(self)

   def __init__(self, dial_group = None, window_group = None, window_title = "", additional_text = None, actionok = None, actioncancel = None):
      gtk.Dialog.__init__(self, window_title, None, gtk.DIALOG_DESTROY_WITH_PARENT, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OK, gtk.RESPONSE_OK))
      if window_group is not None:
         window_group.add_window(self)
      self.set_icon_from_file(pkgdatadir + "icon" + gfext)
      self.set_resizable(False)
      self.connect("close", self.respond, actionok, actioncancel)
      self.connect("response", self.respond, actionok, actioncancel)
      self.connect("window-state-event", self.window_attn)
      self.set_default_response(gtk.RESPONSE_OK)
      
      hbox = gtk.HBox(False, 20)
      hbox.set_border_width(20)
      self.vbox.pack_start(hbox, True, True, 0)
      hbox.show()
      image = gtk.Image()
      image.set_from_stock(gtk.STOCK_DIALOG_WARNING, gtk.ICON_SIZE_DIALOG)
      hbox.pack_start(image, True, True, 0)
      image.show()
      vbox = gtk.VBox()
      vbox.set_spacing(8)
      hbox.pack_start(vbox, True, True, 0)
      vbox.show()
      
      if additional_text is not None:
         if type(additional_text) is str:
            additional_text = additional_text.splitlines()
         for each in additional_text:
            label = gtk.Label()
            attrlist = pango.AttrList()
            attrlist.insert(pango.AttrSize(12500, 0, len(each)))
            label.set_attributes(attrlist)
            label.set_text(each)
            vbox.add(label)
            label.show()
      if dial_group is not None:
         dial_group.add(self)
      self.dial_group = dial_group
      # Dialog is not shown upon creation, but rather is (re)shown when needed.
