/*
#   askxine.c: a xine-lib non-player used for getting audio metadata
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#define XINE_ENABLE_EXPERIMENTAL_FEATURES

#include <stdio.h>
#include <stdlib.h>
#include <xine.h>
#include <xine/xineutils.h>
#include "askxine.h"

#define TRUE 1
#define FALSE 0

static xine_t *askxine; 
static xine_stream_t *stream;
static xine_audio_port_t *ao_port;
static xine_audio_frame_t frame;
static char *configfile;

int askxine_create()
   {
   const char *xinehomedir;
   
   if ((askxine = xine_new()))
      {
      if (!(configfile = malloc(strlen(xinehomedir = xine_get_homedir()) + 19)))
         {
         fprintf(stderr, "malloc failure\n");
         exit(5);
         }
      sprintf(configfile, "%s%s", xinehomedir, "/.idjc/xine-config");
      xine_config_load(askxine, configfile);
      xine_init(askxine);
      return TRUE;
      }
   else
      return FALSE;
   }
   
void askxine_destroy()
   {
   xine_exit(askxine);
   free(configfile);
   }

void askxine_getmetadata(char *pathname)
   {
   int pos_stream, pos_time, length_time;
   const char *meta;
   
   ao_port = xine_new_framegrab_audio_port(askxine);
   stream = xine_stream_new(askxine, ao_port, NULL);
   if (!xine_open(stream, pathname))
      {
      fprintf(stderr, "askxine: error\n");
      goto exit;
      }
   if (!xine_get_stream_info(stream, XINE_STREAM_INFO_AUDIO_HANDLED))
      {
      fprintf(stderr, "askxine: error\n"); 
      goto exit;
      }
   if (!xine_play(stream, 0, 0))
      {
      fprintf(stderr, "askxine: error\n");
      goto exit;
      }
   if (!xine_get_next_audio_frame(ao_port, &frame))
      {
      fprintf(stderr, "askxine: error\n");
      xine_close(stream);
      goto exit;
      }
   xine_get_pos_length(stream, &pos_stream, &pos_time, &length_time);
   xine_free_audio_frame(ao_port, &frame);

   fprintf(stdout, "askxine: length=%d\n", (length_time + 500) / 1000);
   if (!(meta = xine_get_meta_info(stream, XINE_META_INFO_ARTIST)))
      meta = "";
   fprintf(stdout, "askxine: artist=%s\n", meta);
   if (!(meta = xine_get_meta_info(stream, XINE_META_INFO_TITLE)))
      meta = "";
   fprintf(stdout, "askxine: title=%s\n",  meta);
   
   xine_close(stream);
   exit:
      xine_dispose(stream);
      xine_close_audio_driver(askxine, ao_port);
      fprintf(stdout, "askxine: done\n");
      fflush(stdout);
   }
