/*
#   noisegate.c: The noisegate used by IDJC.
#   Copyright (C) 2005-2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "dbconvert.h"
#include "noisegate.h"

#define TRUE 1
#define FALSE 0

ngate_t noisegate(struct noisegate *self, ngate_t signal)
   {
   ngate_t diff, sig_db;
   
   sig_db = level2db(signal);
   
   if (self->mute_state == FALSE)
      {
      if (sig_db < self->thresh - self->hyster * 0.5F)
	 {
	 if (++self->delaycount > self->offdelay)
	    self->mute_state = TRUE;
	 }
      else
         {
	 self->delaycount = 0;
         if (self->gain > -0.0000004F)
            self->gain = 0.0F;
         else
            self->gain += -self->gain * self->ontime;
	 }	 
      }
   if (self->mute_state == TRUE)
      {
      if (sig_db > self->thresh + self->hyster * 0.5F)
         {
         self->mute_state = FALSE;
	 self->delaycount = 0;
	 }
      else
         {
         if ((diff = self->attenuation - self->gain) < -0.01)
            self->gain += diff * self->offtime;
         if (self->gain < self->attenuation)
            self->gain = self->attenuation;
         } 
      } 	
   return self->gain; 
   }
