/*
#   rms_calc.h: generate a running rms count of the signal level
#   Copyright (C) 2006 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <jack/jack.h>

typedef jack_default_audio_sample_t rmsaudio_t;

struct rms_calc
   {
   rmsaudio_t *buffer;
   rmsaudio_t *end;
   rmsaudio_t *ptr;
   rmsaudio_t sum;
   rmsaudio_t newsum;		/* value used to prevent drift */
   rmsaudio_t multiplier;
   };
   
rmsaudio_t rms_calc(struct rms_calc *, rmsaudio_t);
struct rms_calc *rms_calc_create(int sr, float length);
void rms_calc_destroy(struct rms_calc *);
