/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <playlist/playlistloader.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qxml.h>
#include <qurl.h>

PlaylistLoader::PlaylistLoader()
   {}

PlaylistLoader::~PlaylistLoader()
   {}

bool PlaylistLoader::load(QFile &playlistfile, int opt)
   {
   switch (opt)
      {
      default:
      case M3U:
      case EXTM3U:
         return loadM3U(playlistfile, opt);
      case PLS:
         //return loadPLS(playlistfile, opt);
      case XMLPlaylist:
         //return loadXML(playlistfile, opt);
         break;
      }
   return false;
   }

void PlaylistLoader::readItem(const QMap<QString,QString> &properties)
   {
   QString FileName, Title, Length;

   for (QMap<QString,QString>::ConstIterator i=properties.begin(); i!=properties.end(); ++i )
      {
      QString n = i.key();
      QString val = i.data();

      if ((n == "url") || (n == "file"))
         {
         FileName = val;
         }
      else if (n == "title")
         {
         Title = val;
         }
      else if (n == "length")
         {
         Length = val;
         }
      }

   PlayListEntry NewEntry(FileName, Title, Length);
   list.append(NewEntry);
   }

bool PlaylistLoader::loadM3U(QFile &playlistfile, int /*opt*/)
   {
   playlistfile.open(IO_ReadOnly);
   QTextStream t(&playlistfile);

   bool isExt = false; // flag telling if we load an EXTM3U file
   QString filename;
   QString extinf;
   QMap<QString,QString> prop;
   reset();

   while (!t.eof())
      {
      if (isExt)
         {
         extinf = t.readLine();
         if (!extinf.startsWith("#EXTINF:"))
            {
            filename = extinf;
            extinf="";
            }
         else
            {
            filename = t.readLine(); // read in second line containing the filename
            }
         }
      else // old style m3u
         {
         filename = t.readLine();
         }

      if (filename == "#EXTM3U") // on first line
         {
         isExt=true;
         continue; // skip parsing the first (i.e. this) line
         }

      if (filename.isEmpty())
         continue;

      QUrl protourl(filename);
      if (protourl.isLocalFile())
         {
         prop["url"] = protourl.path(true);
         prop["title"] = prop["url"];
         }
      else // don't handle non-local files
         {
         continue;
         }

      // parse line of the following format:
      //#EXTINF:length,displayed_title
      if (isExt)
         {
         extinf.remove(0,8); // remove "#EXTINF:"
         int timeTitleSep = extinf.find(',', 0);

         int length = (extinf.left(timeTitleSep)).toInt();
         if (length>0)
            prop["length"]=QString::number(length*1000);

         QString displayTitle=extinf.mid(timeTitleSep+1);
         if (!displayTitle.isEmpty())
            {
            int artistTitleSep = displayTitle.find(" - ",0);
            if (artistTitleSep == -1) // no "artist - title" like format, just set it as title
               {
               prop["title"] = displayTitle;
               }
            else
               {
               prop["author"] = displayTitle.left(artistTitleSep);
               prop["title"] = displayTitle.mid(artistTitleSep+3);
               }
            } // END !displayTitle.isEmpty()
         } // END if(isExt)

      readItem(prop);
      prop.clear();
      } // END while()

   return true;
   }

int PlaylistLoader::sizeOfPlaylist()
   {
   int filesize;
   PlayList::iterator it;
   QFileInfo finfo;

   filesize = 0;
   for(it = list.begin(); it != list.end(); ++it)
      {
      finfo.setFile((*it).filename());
      if (finfo.isFile())
         {
         filesize += finfo.size();
         }
      }
   return(filesize);
   }

int PlaylistLoader::numFilesInPlaylist()
{
   int count;
   PlayList::iterator it;

   count = 0;
   for(it = list.begin(); it != list.end(); ++it)
      {
      count++;
      }
   return(count);
}
