/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


#include "iqt.h"
#include "ivtk.h"
#include "idatareader.h"

#ifdef QT_THREAD_SUPPORT
#include <qthread.h>
#endif
#include <qapplication.h>


//
//  Helper class
//
#ifdef QT_THREAD_SUPPORT

class iLoadFileThread : public QThread
{

public:

	iLoadFileThread(iDialogLoadFile *m){ myLoadFile = m; }
	virtual void run()
	{ 
		myLoadFile->load(); 
	}

private:

	iDialogLoadFile* myLoadFile;

};

#endif

//
//  Main class
//

void iDialogLoadFile::init()
{

	this->setWFlags(this->getWFlags() | WDestructiveClose);
#ifdef QT_THREAD_SUPPORT
	myThread = new iLoadFileThread(this);
#else
	myThread = 0;
#endif
	myReader = 0;
    timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(checkIfFinished()) );

}


void iDialogLoadFile::interrupt()
{
#ifdef QT_THREAD_SUPPORT
	if(myReader!=0 && myThread!=0 && !myThread->finished()) 
	{
		myReader->abort();
	}
#endif
}


void iDialogLoadFile::checkIfFinished()
{
#ifdef QT_THREAD_SUPPORT
	if(myThread !=0 && myThread->finished()) 
	{
		timer->stop();
		delete myThread;
		myThread = 0;
		if(myReader != 0) myReader->setProgressBar(mode,0);
		emit finished(myReader,mode,filename,flags,ret);
		this->close();
	}
#endif
}


void iDialogLoadFile::show(iDataReader* r, int m, iString fn, bool is, bool jcfe, bool sitl, int f)
{
#ifdef QT_THREAD_SUPPORT
	if(r==0 || myReader!=0) return; 
	if(r->isProgressBarActive(m)) return;

	if(r != 0)
	{
		myReader = r;
		mode = m;
		filename = fn;
		inSet = is;
		justCheckIfExists = jcfe;
		saveInTheList = sitl;
		flags = f;
		FilenameTextLabel->setText(filename);
		myReader->detachData(0,mode);
		myReader->setProgressBar(mode,ProgressBar);

		QDialog::show();
	    timer->start(100); 
		myThread->start();
	}
#endif
}


void iDialogLoadFile::load()
{
	switch (mode)
	{
	case IDATAREADER_MESH: 
		{
			ret = myReader->loadMeshFile(filename,inSet,justCheckIfExists,saveInTheList);
			break;
		}
	case IDATAREADER_PART: 
		{
			ret = myReader->loadPartFile(filename,inSet,justCheckIfExists,saveInTheList);
			break;
		}
	case IDATAREADER_VECT: 
		{
			ret = myReader->loadVectFile(filename,inSet,justCheckIfExists,saveInTheList);
			break;
		}
	case IDATAREADER_TENS: 
		{
			ret = myReader->loadTensFile(filename,inSet,justCheckIfExists,saveInTheList);
			break;
		}
	case IDATAREADER_ALL: 
		{
			ret = myReader->loadFileSet(filename,saveInTheList);
			break;
		}
	default: ret = -999;
	}
}


void iDialogLoadFile::exec()
{
}


void iDialogLoadFile::show()
{
}


