/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "idialogpickextension.h"

#include "ivtk.h"
#include "ivtkwindow.h"
#include "ipicker.h"

#include <vtkRenderWindow.h>
#include <vtkRenderer.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkInteractorStyle.h>


void iDialogPick::init()
{

	picker = 0;

	ext = new iDialogPickExtension(this);
	if(ext != 0)
	{
		this->setExtension(ext);
		this->setOrientation(Qt::Vertical );
		this->showExtension(false);
	}
	else this->accept();

}


void iDialogPick::destroy()
{
	if(ext != 0) delete ext;
}


void iDialogPick::displayData(iPicker *p)
{
	picker = p;
	if(ext!=0 && p!=0 && picker->GetProp()!=0)
	{
		Pick_WaitTextLabel->setText("Picked point:");
		picker->getVTK()->showPickedPoint(true);
		ext->displayData(p);
		this->showExtension(true);
		picker->getVTK()->Render();
	}
	else 
	{
		Pick_WaitTextLabel->setText("Nothing is picked.");
		if(ext != 0) this->showExtension(false);
	}

}


void iDialogPick::show()
{
	Pick_WaitTextLabel->setText(QString("Please wait, the data are being gathered..."));
	QDialog::show();
}


void iDialogPick::closeEvent(QCloseEvent *e)
{
	if(picker != 0)
	{
		if(picker->GetProp() != 0) ((vtkInteractorStyle *)picker->GetRenderer()->GetRenderWindow()->GetInteractor()->GetInteractorStyle())->HighlightProp(NULL);
		picker->getVTK()->showPickedPoint(false);
		picker->getVTK()->Render();
	}
    e->accept(); 
}


void iDialogPick::showExtended()
{
	QDialog::show();
	if(picker == 0) picker = iVTKWindow::getCurrentWindow()->getPicker();
	this->displayData(picker);
	this->showExtension(true);
}
