/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iglobals.h"

#include "ivtk.h"
#include "ivtkwindow.h"
#include "ianimator.h"
#include "ianimatorscript.h"
#include "iscript.h"

#include <qheader.h>


using namespace iScriptType;


QPixmap image(char *);


void iDialogScriptVariablesView::init()
{

	closeable = false;

	ListView->addColumn(trUtf8("Variable"));
    ListView->addColumn(trUtf8("Type"));
    ListView->addColumn(trUtf8("Value"));

	ListView->header()->setClickEnabled(false,0);
	ListView->header()->setClickEnabled(false,1);
	ListView->header()->setClickEnabled(false,2);

	ListView->setColumnWidthMode(2,QListView::Maximum);
	ListView->setSorting(-1);
	ListView->setSelectionMode(QListView::Single);

	PushButtonMoveUp->setPixmap(image("moveup.png"));
	PushButtonMoveDown->setPixmap(image("movedown.png"));
	PushButtonMoveTop->setPixmap(image("movetop.png"));

}


void iDialogScriptVariablesView::destroy()
{

}


void iDialogScriptVariablesView::show()
{

	int i, n;
	QString s;

	n = iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getNumberOfVariables();
	ListView->clear();

	for(i=0; i<n; i++)
	{
		this->updateVariable(i);
	}
	ListView->setCurrentItem(ListView->firstChild());

	QWidget::show();
}


void iDialogScriptVariablesView::closeEvent(QCloseEvent *e)
{
    if(closeable) e->accept(); 
}


void iDialogScriptVariablesView::reallyClose()
{
    closeable = true;
    this->close();
}


void iDialogScriptVariablesView::updateVariable(int i)
{
	int i1, i2;
	iValue *val;

	if(i < -1) return;

	if(i == -1)
	{
		i1 = 0;
		i2 = iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getNumberOfVariables();
	}
	else
	{
		i1 = i;
		i2 = i + 1;
	}

	for(i=i1; i<i2; i++)
	{
		val = iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getVariable(i);
		if(val != NULL)
		{
			QListViewItem *it = ListView->findItem(val->getName(),0);
			if(it == NULL) 
			{
				it = new QListViewItem(ListView,val->getName(),val->getTypeAsText(),val->getValueAsText());
				it->setDragEnabled(true);
				it->setDropEnabled(true);
			}
			else
			{
				it->setText(2,val->getValueAsText());
				ListView->setCurrentItem(it);
			}
		}
	}

	ListView->ensureItemVisible(ListView->currentItem());

}


void iDialogScriptVariablesView::moveUp()
{
	if(ListView->currentItem()!=NULL && ListView->currentItem()->itemAbove()!=NULL)
	{
		QListViewItem *it = ListView->currentItem();
		if(it->itemAbove()->itemAbove() != NULL)
		{
			it->moveItem(it->itemAbove()->itemAbove());
		}
		else
		{
			ListView->takeItem(it);
			ListView->insertItem(it);
			ListView->setCurrentItem(it);
		}
		ListView->ensureItemVisible(ListView->currentItem());
	}
}


void iDialogScriptVariablesView::moveDown()
{
	if(ListView->currentItem()!=NULL && ListView->currentItem()->itemBelow()!=NULL)
	{
		QListViewItem *it = ListView->currentItem();
		it->moveItem(it->itemBelow());
	}
}


void iDialogScriptVariablesView::moveTop()
{
	QListViewItem *it = ListView->currentItem();
	if(it != NULL)
	{
		ListView->takeItem(it);
		ListView->insertItem(it);
		ListView->setCurrentItem(it);
		ListView->ensureItemVisible(ListView->currentItem());
	}
}


