/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IFAMILY_H
#define IFAMILY_H

class iVTK;


void reportNullPointer(int);


template<class T>
class iFamily 
{

public:

	iFamily(iVTK *m = 0);
	virtual ~iFamily();
	inline int getMaxMemberIndex(){ return this->max; }
	inline int getCurrentMemberIndex(){ return this->cur; }
    T* getCurrentMember() { return this->memlist[this->cur]; }
    T* getMember(int i) { if(i>=0 && i<=this->max) return this->memlist[i]; else return 0; }
    void setCurrentMemberIndex(int i) { if(i>=0 && i<=this->max) this->cur = i; }
	virtual int createMember();
	virtual bool deleteMember(int i);

protected:

	T* New();
	T **memlist; 
	int cur, max, maxMax;
	iVTK *myVTK;

};


template<class T>
iFamily<T>::iFamily(iVTK *m)
{
	int i;

	this->myVTK = m;

	this->cur = this->max = 0;
	this->maxMax = 100;

	this->memlist = new T*[this->maxMax];
	if(this->memlist == 0) reportNullPointer(2501);

	this->memlist[0] = New();
	if(this->memlist[0] == 0) reportNullPointer(2502);
    for(i=1; i<this->maxMax; i++)  this->memlist[i] = 0;

}


template<class T>
iFamily<T>::~iFamily()
{
	int i;
    for(i=0; i<=this->max; i++) delete this->memlist[i];
	delete [] this->memlist;
}


template<class T>
T* iFamily<T>::New()
{
	return T::New(this->myVTK);
}


template<class T>
int iFamily<T>::createMember()
{

	if(this->max+1 == this->maxMax)
	{
		//
		//  Extend array if too small
		//
		this->maxMax += 100;
		T** newMemlist = new T*[this->maxMax];
		if(newMemlist == 0) return -1;

		int i;
		for(i=0; i<=this->max; i++) newMemlist[i] = this->memlist[i];
		delete [] this->memlist;
		this->memlist = newMemlist;

	}

	this->max++;
	this->memlist[this->max] = this->New();
	if(this->memlist[this->max] == 0) { this->max--; return -1; }
	return this->max;

}


template<class T>
bool iFamily<T>::deleteMember(int i)
{
	int j;

	if(i>=0 && i<=this->max && this->max>0)
	{
		delete this->memlist[i];
		for(j=i; j<this->max; j++) this->memlist[j] = this->memlist[j+1];
		this->memlist[this->max] = 0;
		if(this->cur > i) this->cur--;
		this->max--;
		if(this->cur > this->max) this->cur = this->max;
		return true;
    }
	else return false;

}


#endif // IFAMILY_H
