/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iglobals.h"
#include "ilegend.h"
#include "ivtk.h"

#include <vtkMath.h>
#include <vtkRenderer.h>
#include <vtkCamera.h>
#include <vtkProperty2D.h>
#include <vtkTextMapper.h>

#ifndef I_VTK_VERSION_40
#include <vtkTextProperty.h>
#endif

void reportNullPointer(int);


iLegend* iLegend::New()
{
	return new iLegend;
}


iLegend::iLegend()
{

	fontSize = 12;

	this->BorderOn(); 
	this->GetPositionCoordinate()->SetCoordinateSystemToNormalizedViewport();
	this->GetPosition2Coordinate()->SetCoordinateSystemToNormalizedViewport();
	this->GetPosition2Coordinate()->SetReferenceCoordinate(this->GetPositionCoordinate());
	this->SetPosition2(0.25,0.08);
	this->BorderOn();
	this->LockBorderOn();
	this->GetProperty()->SetColor(0.0,0.0,0.0);
	this->GetProperty()->SetLineWidth(2.0);
#ifndef I_VTK_VERSION_40
	this->GetEntryTextProperty()->SetFontFamilyToArial();
	this->GetEntryTextProperty()->BoldOn();
	this->GetEntryTextProperty()->ItalicOff();
	this->GetEntryTextProperty()->ShadowOn();
	this->GetEntryTextProperty()->SetJustificationToLeft(); 
	this->GetEntryTextProperty()->SetVerticalJustificationToCentered();
	this->GetEntryTextProperty()->SetColor(0.0,0.0,0.0);
#else
	this->ItalicOff();
	this->ShadowOn();
	this->BoldOn();
#endif

	this->PickableOff();

}


iLegend::~iLegend()
{
}


void iLegend::ReleaseGraphicsResources(vtkWindow *win)
{
	this->vtkLegendBoxActor::ReleaseGraphicsResources(win);
}


int iLegend::RenderOverlay(vtkViewport* viewport)
{
	int ret = 0;
	ret += this->vtkLegendBoxActor::RenderOverlay(viewport);
	return ret;
}


int iLegend::RenderOpaqueGeometry(vtkViewport* viewport)
{

	vtkCamera *cam = ((vtkRenderer *)viewport)->GetActiveCamera();
	if(cam == 0) return 0;
	
	iVTK *vtk = iVTK::convertFromViewport(viewport);

	int ret = 0;
	//
	//  Maintain the font size
	//
	vtkFloat *x1 = this->GetPosition();
	vtkFloat *x2 = this->GetPosition2();
	int mag = vtk->getRenderingMagnification();
	int *size = viewport->GetSize();

	float s = (fontSize*NumberOfEntries+(NumberOfEntries+1)*Padding)/fabs(size[1]*x2[1]);

	if(mag == 1)
	{
		unmagx1[0] = x1[0];
		unmagx1[1] = x1[1];
		unmagx2[0] = s*x2[0];
		unmagx2[1] = s*x2[1];
		//
		//  Corrections
		//
		if(unmagx2[0] > 0.25) unmagx2[0] = 0.25;
		if(unmagx2[1] > 0.16) unmagx2[1] = 0.16;
		if(unmagx1[0] > 0.5) 
		{
			unmagx1[0] = 0.98 - unmagx2[0];
			this->SetPosition(unmagx1[0],unmagx1[1]);
		}
	}
	else
	{

		int winij[2];
		vtk->computePositionShiftsUnderMagnification(winij,viewport);
		
		this->SetPosition(mag*unmagx1[0]-winij[0],mag*unmagx1[1]-winij[1]);
		this->Padding *= mag;

	}
	
	this->SetPosition2(unmagx2[0]*mag,unmagx2[1]*mag);

	//
	//  Scale lines
	//
	this->GetProperty()->SetLineWidth(2*mag);

#ifndef I_VTK_VERSION_40
	//
	//  This fixes a bug in vtkLegendBoxActor::RenderOpaqueGeometry - when NumberOfEntries increases, new
	//  entries do not get assigned the text property
	//
	int i;
    if(this->EntryTextProperty->GetMTime()>this->BuildTime || this->GetMTime()>this->BuildTime)
	{
		for(i=0; i<this->NumberOfEntries; i++)
        {
			this->TextMapper[i]->GetTextProperty()->ShallowCopy(this->EntryTextProperty);
        }
	}
#endif

	ret = this->vtkLegendBoxActor::RenderOpaqueGeometry(viewport);
	
#ifndef I_VTK_VERSION_40
	//
	//  Redo text colors and rerender them
	//
    for(i=0; i<this->NumberOfEntries; i++)
	{
		this->TextMapper[i]->GetTextProperty()->SetColor(EntryTextProperty->GetColor());
	    this->TextActor[i]->RenderOpaqueGeometry(viewport);
    }
#endif
	
	//
	//  Reset to the unmagnified state
	//
	if(mag > 1)
	{
		this->SetPosition(unmagx1[0],unmagx1[1]);
		this->SetPosition2(unmagx2[0],unmagx2[1]);
		this->Padding /= mag;
	}
	
	return ret;
	
}


void iLegend::setFontSize(int s)
{ 
	if(s>0 && s<99) fontSize = s; 
}




