/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ivtk.h"
#include "iqt.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"
#include "iglobals.h"
#include "iqtextension.h"

#include "iqtdefs.h"
#include "iqt_view.h"
#include "iqt_surf.h"
#include "iqt_xsec.h"
#include "iqt_volv.h"
#include "iqt_part.h"
#include "iqt_vect.h"
#include "iqt_tens.h"
#include "iqt_data.h"

#include "iqt_view.h"
#include "iqt_xsec.h"
#include "idialogscripter.h"
#include "ieditor.h"

#include "ianimatorscript.h"
#include "ianimator.h"
#include "ierror.h"
#include "idatareader.h"
#include "ixsection.h"
#include "iprogressbar.h"
#include "ivtkcallback.h"

#include <qaction.h>
#include <qapplication.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qprogressbar.h>
#include <qprogressdialog.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qmessagebox.h>


void iSleep(int);


//
// *********************************************************************************
//
//  
//   slots related to animation making
//
//
// *********************************************************************************
//

void iQT::animate()
{

	if(!Button_Animate->isEnabled())
	{
		this->popupInfo("Animatable data file is not loaded.\n Please, load the data file.");
		return;
	}

	if(!iVTKWindow::getCurrentWindow()->getAnimator()->isCameraPathValid())
	{
		this->popupInfo("Camera path is invalid: \ncamera position and focal point coincide somewhere along the path.\nPlease, fix the path and try again.");
		return;
	}

    if(inUpdate)
	{
		stopAnimation = 1;
		return; 
    }
	
    if(stopAnimation != 0)
	{
		stopAnimation = 0;
		return; 
    }
	
    inUpdate = true;
    
	TabWidget->blockSignals(true);
	if(ext != NULL) ext->blockSignals(true);
	
	iVTKWindow::getCurrentWindow()->raise();
	
    stopAnimation = 0;
    CALL_FUNCTION1(Button_Animate,setText,QString("Pause"));
	qApp->flush();
    qApp->processEvents();
	//
	//  Disactivate Progress Dialog
	//
    iVTKWindow::getCurrentWindow()->getAbortRenderEventObserver()->setProgressDialog(0);
	//
	//  Init animator
	//
	this->animateStart();
	//
	//  call animator
	//
	int ret = iVTKWindow::getCurrentWindow()->getAnimator()->animate();
    
	if(stopAnimation == 1)
	{
		CALL_FUNCTION0(Button_Animate,animateClick);
		this->logLine("Animation","Animation was terminated."); 
		ret = 0;
	}

	this->animateReportError(ret,stopAnimation);
    //
	//  finish animating
	//
	this->animateFinish();

    iVTKWindow::getCurrentWindow()->getAbortRenderEventObserver()->setProgressDialog(ProgressDialog);

    CALL_FUNCTION1(Button_Animate,setText,QString("Animate"));
    inUpdate = false;
	
	TabWidget->blockSignals(false);
	if(ext != NULL) ext->blockSignals(false);
    
}


void iQT::animateStart()
{

	//
	//  Save the original state to restore after execution of a script
	//
	iVTKWindow::getCurrentWindow()->getAnimator()->saveState();
	
	if(iVTKWindow::getCurrentWindow()->getAnimator()->getUseScript() && !iVTKWindow::getCurrentWindow()->getAnimator()->getInheritSettings()) iVTKWindow::getCurrentWindow()->getAnimator()->resetState();
	iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->setText(AnimationScripter->TextWindow->text());

	AnimationScripter->runStart();

}


void iQT::animateFinish()
{

	AnimationScripter->runFinish();
	//
	//  Restore the original view
	//
	iVTKWindow::getCurrentWindow()->getAnimator()->reset();
	//
	//  Restore the original state after execution of a script - must do it after reset()
	//  so that projection is set properly in case it was changed in a script before the
	//  first render
	//
	iVTKWindow::getCurrentWindow()->getAnimator()->restoreState();
    //
	// Update all widgets if some of iVisualObject setting changed
	//
	this->updateWidgets(-1);
	//
	//  Final render
	//
    this->render(false);

}


bool iQT::animateBreak(int lineInScript, int entryPointInteration, int entryPointIterationCount, int userCode)
{

	qApp->flush();
	qApp->processEvents();

	if(stopAnimation) 
	{
		switch (QMessageBox::warning(iQTWindow::getCurrentWindow(),"IFRIT","Animation is paused","Continue","Stop",0,0,1))
		{
		case 0: 
			{
				stopAnimation = 0;
				break;
			}
		case 1: 
			{
				return true;
			}
		}			
	}

	if(AnimationScripter->isVisible()) 
	{ 
		AnimationScripter->showScriptLine(lineInScript,entryPointInteration,entryPointIterationCount,true);  
		qApp->flush(); qApp->processEvents();
	}

	if(userCode == 1)
	{
		bool newRec;
		int curRec, curFrm;
		QString s, s1;
		iVTKWindow::getCurrentWindow()->getAnimator()->getInfo(newRec,curRec,curFrm);
		if(newRec) ProgressBar->reset();
		s = "record #" + s1.setNum(curRec);
		s += ",  frame #" + s1.setNum(curFrm);
		logLine("Animating",s);
	}

	return false;

}


void iQT::animateShowLine(int lineInScript)
{
	if(AnimationScripter->isVisible()) 
	{ 
		AnimationScripter->showScriptLine(lineInScript,-1,0,false); 
		qApp->flush(); qApp->processEvents();
		iSleep(AnimationScripter->getDelay()); 
	}
}


#define ANIMERROR(msg) { if(showPopup) this->popupInfo(msg); this->logLine("Animation",msg,red); }

void iQT::animateReportError(int ret, int stopAnimation)
{
	static bool showPopup = true;

	int l = iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getCurrentLine();
	//
	//  Error control
	//
	switch(ret)  // this may differ from ret
	{
	case 1:
		{
			//
			//  Compilation failed.
			//
			ANIMERROR("Compilation error, line "+QString::number(l)+":\n"+iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getErrorMessage());
			break;
		}
	case 2:
		{
			//
			//  Execution failed.
			//
			if(iVTKWindow::getCurrentWindow()->getAnimator()->getReturnCode() != 0) ANIMERROR("Execution error, line "+QString::number(l)+":\n"+iVTKWindow::getCurrentWindow()->getAnimator()->getScript()->getErrorMessage());
			break;
		}
	case 3:
		{
			//
			//  Script was terminated. Was it due to an error in Animator?
			//
			if(stopAnimation == 0)
			{
				//
				//  Return codes
				//
				//		 0:		all is ok
				//		-1:		cannot perform off-screen rendering
				//		-2:		no renderer
				//		-3:		no data reader
				//		-10:	file is not animatable
				//		-9:		last file read
				//
				switch(iVTKWindow::getCurrentWindow()->getAnimator()->getReturnCode())
				{
				case  -1: { ANIMERROR("Cannot perform off-screen rendering."); break; }
				case  -2: { ANIMERROR("No renderer is specified."); break; }
				case  -3: { ANIMERROR("No data reader is specified."); break; }
				case -10: { ANIMERROR("File is not animatable."); break; }
				case  -9: { if(iVTKWindow::getCurrentWindow()->getAnimator()->getUseScript()) ANIMERROR("Animation has not completed because of lack of data files."); break; }
				}
			}
			break;
		}
	}
	
}

