/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/



#include "iqtdefs.h"

#include "ivtk.h"
#include "iqt.h"
#include "ivtkwindow.h"
#include "idatareader.h"

#include <qstatusbar.h>
#include <qtextstream.h>


QPixmap image(char *s);


void iQTExtension::init()
{
    closeable = false;
    initialized = false;
    active = false;  // only non-empty extensions are active
	//
	//  define myQT
	//
	myQT = (iQT *)parentWidget();
	//
	//  Un-parent so that the extension window is free-floating
	//
	this->reparent(0,QPoint(50,50));
	//
	//  we don't need a status bar in this window
	//
	delete this->statusBar();
}


void iQTExtension::fileOpen()
{
}


void iQTExtension::fileOpen(int mode, const QString &s)
{
}


void iQTExtension::helpContents()
{
}


void iQTExtension::setCloseable()
{
    closeable = true;
}


void iQTExtension::closeEvent(QCloseEvent *e)
{
    if(closeable) e->accept();
}


void iQTExtension::styleTab(int m)
{
    if(m == 1)
	{
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_SURF),QPixmap(),QString("Surface"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_XSEC),QPixmap(),QString("X-section"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VOLV),QPixmap(),QString("Volume"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_PART),QPixmap(),QString("Particles"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VECT),QPixmap(),QString("Vector"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_TENS),QPixmap(),QString("Tensor"));
	}
    if(m == 2)
	{
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_SURF),image("surf.png"),QString(""));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_XSEC),image("xsec.png"),QString(""));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VOLV),image("volv.png"),QString(""));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_PART),image("part.png"),QString(""));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VECT),image("vect.png"),QString(""));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_TENS),image("tens.png"),QString(""));
	}
    if(m == 3)
	{
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_SURF),image("surf.png"),QString("Surface"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_XSEC),image("xsec.png"),QString("X-section"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VOLV),image("volv.png"),QString("Volume"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_PART),image("part.png"),QString("Particles"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_VECT),image("vect.png"),QString("Vector"));
		TabWidget->changeTab(TabWidget->page(DISPLAYPAGE_TENS),image("tens.png"),QString("Tensor"));
	}
	
}


void iQTExtension::updateTabWidgetPage(int m)
{
	TabWidget->setCurrentPage(m);
}


void iQTExtension::updateExtensionTabWidgetPage(QWidget *w)
{
    int j;
    for(j=1; j<7; j++) if(w == TabWidget->page(j)) 
    {
	CALL_FUNCTION1(myQT->TabWidget,setCurrentPage,j);
	break;
    }
}


bool iQTExtension::isActive()
{
    return active;
}


void iQTExtension::updateWidgets( int m )
{
}


void iQTExtension::updateSwitches( int m )
{
}


void iQTExtension::updateViews(bool s)
{
}


void iQTExtension::finishInitialization()
{
    if(initialized) return;
    initialized = true;
}


void iQTExtension::setPickerObjectInfo(iDialogPickExtension* dialog, iPicker *picker, int otype)
{
}


void iQTExtension::setPickerDataInfo(iDialogPickExtension* dialog, iPicker *picker, int dtype)
{
}


void iQTExtension::optionsSaveObjects(QTextStream& optionsStream, int k)
{
}


void iQTExtension::optionsLoadPreProcess()
{
}


bool iQTExtension::optionsLoadObjects(QString s, char* name, int& joff, int nVTK)
{
    return true;
}


void iQTExtension::optionsLoadColorLabel(char *name, QColor c)
{
}


void iQTExtension::optionsLoadPostProcess()
{
}


void iQTExtension::afterFileRead(int wi, int, int res, QString fname)
{
}


void iQTExtension::updateAfterFileRead(iDataReader *reader, int mode, QString filename, int flags, int res)
{
	if(res == -999) return;

	int i;
	for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) if(iVTKWindow::getWindow(i)->getReader()==reader && !iVTKWindow::getWindow(i)->isClone()) break;

	if(i <= iVTKWindow::getMaxWindowIndex())
	{
		this->afterFileRead(i,flags,res,filename);
	}
}


void iQTExtension::updateDataChannel(int mode, int dataChannel)
{
}


void iQTExtension::updateCoordinateDisplays()
{
}


