/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

This file is derived from the file TOOLS\DESIGNER\plugins\cppeditor\syntaxhighliter_cpp.cpp of the
Qt distribution, and fully inherits QT license conditions.

Unmodified parts of the Qt file retain Qt Copyright.

=========================================================================*/
/**********************************************************************
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "isyntaxhighlighter.h"

#define vtkNotUsed(x)


iSyntaxHighlighter::iSyntaxHighlighter()
    : QTextPreProcessor(), lastFormat( 0 ), lastFormatId( -1 )
{
    int normalSize = 10;
    QString normalFamily = "courier";
    int normalWeight = QFont::Normal;
    addFormat( Standard,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::black ) );
    addFormat( Comment,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::darkGreen ) );
    addFormat( Number,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::black ) );
    addFormat( String,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::darkRed ) );
    addFormat( Keyword,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::blue ) );
    addFormat( Variable,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::blue ) );
    addFormat( Parameter,
	       new QTextFormat( QFont( normalFamily, normalSize, normalWeight ), Qt::darkMagenta ) );

	highlightOn = true;

}


iSyntaxHighlighter::~iSyntaxHighlighter()
{
}


void iSyntaxHighlighter::setPointSize(int s)
{
	unsigned int i;
	for(i=0; i<formats.count(); i++)
	{
		this->format(i)->setPointSize(s);
		this->format(i)->setBold((s > 13));
	}
}


void iSyntaxHighlighter::process(QTextDocument *vtkNotUsed(doc), QTextParag *string, int, bool vtkNotUsed(invalidate))
{

	unsigned int i, len, index, index2, indexMax;
    static QString line;
    static QString alphabeth = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    static QString mathChars = "xXeE";
    static QString numbers = "0123456789";

	line = string->string()->toString();
	line = line.left(line.length()-1);
	if(line.isEmpty() || !highlightOn) return;
	//
	//  Highlight comments first
	//
	indexMax = line.find('#',0);
	if(indexMax == -1) 
	{
		indexMax = line.length(); 
	}
	else
	{
		string->setFormat(indexMax,line.length()-indexMax,format(Comment),false);
	}

	if(indexMax == 0) return; // whole line is a comment
		
	string->setFormat(0,indexMax,format(Standard),false);
	//
	//  Highlight reserved words
	//
	for(i=0; i<keywords.count(); i++)
	{
		len = keywords[i].length();
		index = 0;
		while((index=line.find(keywords[i],index))!=-1 && index<indexMax && alphabeth.find(line.at(index-1),0)==-1 && alphabeth.find(line.at(index+len),0)==-1)
		{
			string->setFormat(index,len,format(Keyword),false);
			index += len;
		}
	}
	
	for(i=0; i<variables.count(); i++)
	{
		len = variables[i].length();
		index = 0;
		while((index=line.find(variables[i],index))!=-1 && index<indexMax && alphabeth.find(line.at(index-1),0)==-1 && alphabeth.find(line.at(index+len),0)==-1)
		{
			string->setFormat(index,len,format(Variable),false);
			index += len;
		}
	}

	for(i=0; i<parameters.count(); i++)
	{
		len = parameters[i].length();
		index = 0;
		while((index=line.find(parameters[i],index))!=-1 && index<indexMax && alphabeth.find(line.at(index-1),0)==-1 && alphabeth.find(line.at(index+len),0)==-1)
		{
			string->setFormat(index,len,format(Parameter),false);
			index += len;
		}
	}
	//
	//  Highlight strings
	//
	index2 = -1;
	while((index=line.find('"',index2+1)) != -1)
	{
		index2 = line.find('"',index+1);
		if(index2 == -1) index2 = indexMax - 1; 
		string->setFormat(index,index2-index+1,format(String),false);
	}

}

QTextFormat *iSyntaxHighlighter::format( int id )
{
    if ( lastFormatId == id  && lastFormat )
	return lastFormat;

    QTextFormat *f = formats[ id ];
    lastFormat = f ? f : formats[ 0 ];
    lastFormatId = id;
    return lastFormat;
}

void iSyntaxHighlighter::addFormat( int id, QTextFormat *f )
{
    formats.insert( id, f );
}

void iSyntaxHighlighter::removeFormat( int id )
{
    formats.remove( id );
}

void iSyntaxHighlighter::activate(bool s)
{
    highlightOn = s;
}
