/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*=========================================================================

  Implementation of idataconverter.h
  
=========================================================================*/


#include "iglobals.h"
#include "iuniformmeshdataconverter.h"

#include "iuniformmeshdata.h"
#include "imath.h"
#include "ilimits.h"
#include "ivisualobject.h"

#include <vtkFloatArray.h>
#include <vtkObjectFactory.h>
#include <vtkFloatArray.h>
#include <vtkImageData.h>
#include <vtkStructuredPoints.h>
#include <vtkPointData.h>


void reportNullPointer(int);


//------------------------------------------------------------------------------
iUniformMeshDataConverter* iUniformMeshDataConverter::New(iVisualObject *m)
{
	return new iUniformMeshDataConverter(m);
}


iUniformMeshDataConverter::iUniformMeshDataConverter(iVisualObject *m) : iVisualObjectSource(m)
{
	
	curvar = 1;
	array = vtkFloatArray::New();
	if(array == 0) reportNullPointer(7701);

}


iUniformMeshDataConverter::~iUniformMeshDataConverter()
{
	array->Delete();
}


void iUniformMeshDataConverter::setCurrentVar(int n)
{ 
	
	if(n < 0) return;
	
	if(myObject!=0 && myObject->getLimits()!=0)
	{
		if(n <= myObject->getLimits()->getNvar())
		{
			curvar = n;
			this->Modified();
		}
	}
	else
	{
		curvar = n;
		this->Modified();
	}

}


void iUniformMeshDataConverter::ExecuteData(vtkDataObject *)
{
	iUniformMeshData *input = (iUniformMeshData *)this->GetInput();
	iUniformMeshData *output = (iUniformMeshData *)this->GetOutput();
	int dims[3];
	vtkFloat pos[3];
	
	if(input == 0) return;

	output->ShallowCopy(input);

	int n = input->GetNumberOfScalarComponents();
	if(n == 0) return;
	if (myObject!=0 && n!=myObject->getLimits()->getNvar()){
		return;
    }
	if(curvar<1 || curvar>n){
		curvar = n;
		return;
    }
	
	vtkDebugMacro(<< "Converting StrucuturedPoints to single float");
	//
	input->GetDimensions(dims);
	output->SetDimensions(dims);
	vtkIdType size = (vtkIdType)dims[0]*dims[1]*dims[2];
	
	input->GetSpacing(pos);
	output->SetSpacing(pos);
	
	input->GetOrigin(pos);
	output->SetOrigin(pos);
	
	output->SetScalarTypeToFloat();
	output->SetNumberOfScalarComponents(1);
	
	float *data = (float *)input->GetScalarPointer() + size*(curvar-1);

	array->SetArray(data,size,1);
	output->GetPointData()->SetScalars(array);
	output->Modified();
	this->Modified();
	
}


