/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef IVECTOR_H
#define IVECTOR_H

class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class vtkProperty;
class vtkHedgeHog;
class vtkTubeFilter;
class vtkPolyData;
class vtkExtractVOI;
class vtkPoints;
class vtkRuledSurfaceFilter;

class iPolygonalDataExtender;
class iStreamLine;


#include "ivisualobject.h"
#include "icolor.h"


class iVector : public iVisualObject
{
	
	friend class iObjectFactory;

public:
	
	static iVector* New(iVTK *m = 0);
	virtual ~iVector();
	
	inline int getStartSide(){ return startSide; }
	inline int getPal(){ return pal; }
	inline int getMode() { return mode; }
	inline int getQuality(){ return quality; }
	inline int getColorBy(){ return colorBy; }
	inline int getSampleRate(){ return sampleRate; }
	inline float getHedgeSize(){ return hedgeSize; }
	inline float getLength(){ return length; }
	inline float getPos(){ return pos; }
	inline int getDir(){ return dir; }
	inline iColor getColor(){ return color; }
	inline int getTubeSize(){ return tubeSize; }
	inline float getTubeRangeFactor(){ return tubeRangeFactor; }
	inline float getTubeVariationFactor(){ return tubeVariationFactor; }
	inline int getSourceType(){ return sourceType; }
	
	inline vtkLODActor* getVector(){ return vectorActor; }
	inline vtkPolyDataMapper* getMapper(){ return vectorMapper; }
	inline iPolygonalDataExtender* getExtender(){ return vectorExtender; }
	inline iStreamLine* getStreamLine(){ return vectorLine; }
	
	virtual void setStartSide(int v);
	virtual void setPal(int p);
	virtual void setMode(int m);
	virtual void setTubeSize(int t);
	virtual void setQuality(int q);
	virtual void setColorBy(int q);
	virtual void setSampleRate(int q);
	virtual void setHedgeSize(float q);
	virtual void setLength(float q);
	virtual void setPos(double q);
	virtual void setDir(int n);
	virtual void setColor(iColor q);
	virtual void setTubeRangeFactor(float q);
	virtual void setTubeVariationFactor(float q);
	virtual void setSourceType(int v);
	
	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);
	
	virtual void show(bool s);
	virtual void reset();
	
	virtual void showClipPlane(bool s);
	virtual void showColorBars(bool s);
	
	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

	virtual void updatePipeline();
	virtual void updateSource();

protected:
	
	iVector(iVTK *m = 0);

	virtual void computeSpacing();
	virtual void computeFilterInputParameters(int* dims, vtkFloat* spa, vtkFloat* org);

	iColor color;

	int startSide;
	int mode;
	int pal;
	int tubeSize;
	int quality;
	float hedgeSize;
	int colorBy;
	int sampleRate;
	float length;
	double pos;
	int dir, sourceType;
	float tubeRangeFactor, tubeVariationFactor;
	float curSpacing;
	//
	//  VTK stuff
	//
	vtkLODActor *vectorActor;	
	vtkPolyDataMapper *vectorMapper;
	vtkTubeFilter *vectorTube;
	vtkProperty *vectorProperty;
	vtkHedgeHog *vectorHedge;
	vtkExtractVOI *vectorFilter;
	vtkRuledSurfaceFilter  *vectorRibbons;
	vtkPoints *vectorSource;

	iPolygonalDataExtender *vectorExtender;
	iStreamLine *vectorLine;

};

#endif // IVECTOR_H

