/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Header file for classes that support GUI data structures. They are 
created to minimize interaction berween GUI and VTK. 
*/

#ifndef IVOLUME_H
#define IVOLUME_H

class vtkVolume;
class vtkVolumeProperty;
class vtkVolumeRayCastCompositeFunction;
class vtkVolumeRayCastMIPFunction;
class vtkVolumeRayCastMapper;
class vtkVolumeTextureMapper2D;
class vtkPiecewiseFunction;
class vtkImageData;

class iPiecewiseFunction;
class iVolumeDataConverter;
class iUniformMeshDataExtender;
class iHistogramMaker;
class iUniformMeshDataConverter;

#include <vtkToolkits.h>
//
//  Allow for the IFRIT own support for VolumePro1000
//
#ifdef I_VTK_HAVE_VP1000
	#ifndef VTK_USE_VOLUMEPRO
		#define VTK_USE_VOLUMEPRO
	#endif
	#include "ivolumepromapper.h"
#else
	#ifdef VTK_USE_VOLUMEPRO
		#include <vtkVolumeProMapper.h>
	#else
		#define vtkVolumeProMapper int
	#endif
	#define iVolumeProMapper vtkVolumeProMapper
#endif


#include "ivisualobject.h"
#include "icolor.h"
#include "iglobals.h"



#define IVOLUME_MODE_RAYCAST  0
#define IVOLUME_MODE_TEXTURE  1
#define IVOLUME_MODE_VOLUMEPRO  2

class iVolume : public iVisualObject
{
	
	friend class iObjectFactory;

public:
	
	static iVolume* New(iVTK *m = 0);
	virtual ~iVolume();
	
	inline int getVar(){ return var; }
	inline int getSecondaryVar(){ return secvar; }
	inline int getMode(){ return mode; }
	inline iColor getSecondaryColor(){ return seccolor; }
	inline int getPal(){ return pal; }
	inline int getSecondaryOpacity(){ return secopa; }
	inline iPiecewiseFunction* getOpacityFunction(){ return opa; }
	inline bool getCompositeMethod(){ return compositeMethod; }
	inline bool getInterpolationType(){ return interpolationType; }
	inline float getXYResample(){ return resXY; }
	inline float getZResample(){ return resZ; }
	inline int getBlendMode(){ return blendMode; }
	inline iVolumeDataConverter* getConverter(){ return volumeDataConverter; }
	inline iUniformMeshDataExtender* getExtender(){ return volumeExtender; }
	inline iHistogramMaker* getHistogramMaker(){ return volumeHistogram[dataChannel]; }
	inline iUniformMeshDataConverter* getHistogramConverter(){ return volumeHistogramConverter; }
	inline bool getClipPlaneOn(){ return clipPlaneOn; }
	//
	//  Needed to circumvent VTK bug which does not give access to vtkVolumeMapper::ImageClipper
	//
	virtual vtkImageData* getMapperInput();

	virtual void setShade(bool v);
	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);

	inline vtkVolume* getVolume(){ return volume; }
	
	virtual void setVar(int v);
	virtual void setSecondaryVar(int v);
	virtual void setSecondaryColor(iColor c);
	virtual void setPal(int p);
	virtual void setSecondaryOpacity(int s);

	virtual void show(bool s);
	virtual void reset();

	virtual int changeMode(int m);
	static bool isVolumePro();
	virtual void setCompositeMethod(bool m);
	virtual void setInterpolationType(bool m);
	virtual void setXYResample(float m);
	virtual void setZResample(float m);
	virtual void setBlendMode(int m);

	virtual void showClipPlane(bool s);
	virtual void showColorBars(bool s);
	
	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

protected:
	
	iVolume(iVTK *m = 0);

	int var;
	int secvar;
	int mode;
	iColor seccolor;
	int pal;
	int secopa;
	iPiecewiseFunction* opa;
	
	bool compositeMethod, interpolationType; 
	float resXY, resZ;
	int blendMode;
	//
	//  VTK members
	//
	iVolumeDataConverter *volumeDataConverter;
	iUniformMeshDataExtender *volumeExtender;
	iHistogramMaker *volumeHistogram[MAXDATACHANNEL+1];
	iUniformMeshDataConverter *volumeHistogramConverter;
	iVolumeProMapper *volumeproMapper;
	
	vtkVolume *volume;
	vtkVolumeProperty *prop;
	vtkVolumeRayCastMapper *raycastMapper;
	vtkVolumeTextureMapper2D *textureMapper;
	vtkVolumeRayCastCompositeFunction *compositeFunction;
	vtkVolumeRayCastMIPFunction *mipFunction;
	
};

#endif // IVOLUME_H
 
