/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "imath.h"
#include "ivtkcallback.h"
#include "idialogpick.h"
#include "idialogprogress.h"
#include "iqt.h"
#include "iqtwindow.h"
#include "ivtk.h"
#include "ipicker.h"
#include "idialogeventrecorder.h"

#include <qapplication.h>
#include <qprogressbar.h>

#include <vtkObject.h>
#include <vtkProcessObject.h>
#include <vtkRenderWindow.h>


//
//  iVTKProgressEventObserver class
//
void iVTKProgressEventObserver::Execute(vtkObject *, unsigned long, void *callData)
{
	float f = *((float *)callData);
	if(pb) 
	{
		pb->setProgress(round(f*100.0));
		qApp->flush();
	}
}


void iVTKProgressEventObserver::setProgressBar(QProgressBar *p)
{ 
	pb = p; 
}
//
//  iVTKStartEventObserver class
//
void iVTKStartEventObserver::Execute(vtkObject *, unsigned long, void *)
{
	if(pb) pb->reset();
}


void iVTKStartEventObserver::setProgressBar(QProgressBar *p)
{ 
	pb = p; 
}
//
//  iVTKEndEventObserver class
//
void iVTKEndEventObserver::Execute(vtkObject *, unsigned long, void *)
{
	if(pb) pb->reset();
}


void iVTKEndEventObserver::setProgressBar(QProgressBar *p)
{ 
	pb = p; 
}
//
//  iVTKAbortRenderEventObserver class
//
void iVTKAbortRenderEventObserver::Execute(vtkObject *caller, unsigned long, void *)
{
	if(pd != NULL) 
	{
		pd->keepWorking(); 
		if(pd->isCancelled())
		{
			if(rw != NULL) 
			{
				rw->SetAbortRender(1);
			}
			if(caller != NULL) if(caller->IsA("vtkProcessObject") == 1) 
			{
				((vtkProcessObject *)caller)->SetAbortExecute(1);
			}
		}
	}
}


void iVTKAbortRenderEventObserver::docheck()
{
	this->Execute(0,0,0);
}


void iVTKAbortRenderEventObserver::setProgressDialog(iDialogProgress *p)
{ 
	pd = p; 
}


void iVTKAbortRenderEventObserver::setRenderWindow(vtkRenderWindow *r)
{ 
	if(r != NULL) rw = r; 
}


void iVTKAbortRenderEventObserver::start()
{ 
	if(pd != NULL) pd->start();
}


void iVTKAbortRenderEventObserver::finish()
{ 
	if(pd != NULL) pd->finish(); 
}
//
//  iVTKPickEventObserver class
//
void iVTKPickEventObserver::setDialogPick(iDialogPick *p)
{
	dialog = p;
}

void iVTKPickEventObserver::Execute(vtkObject *caller, unsigned long eventId, void *vtkNotUsed(data))
{

	switch (eventId)
	{
	case vtkCommand::StartPickEvent: 
		{ 
			if(dialog != 0) dialog->show(); 
			break; 
		}
	case vtkCommand::EndPickEvent: 
		{ 
			if(dialog != 0) dialog->displayData((iPicker *)caller); 
			break; 
		}
	default: if(dialog != 0) dialog->close();
	}

}
//
//  iVTKRecordEventObserver class
//
void iVTKRecordEventObserver::setDialogEventRecorder(iDialogEventRecorder *p)
{
	dialog = p;
}

void iVTKRecordEventObserver::Execute(vtkObject *vtkNotUsed(caller), unsigned long eventId, void *vtkNotUsed(data))
{
#ifndef I_VTK_VERSION_40
	if(eventId==vtkCommand::InteractionEvent && dialog!=0) dialog->updateInteraction(); 
#endif
}

