/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef IVTKWINDOW_H
#define IVTKWINDOW_H

class iVTK;

#include "ifamily.h"


#define IVTKWINDOW_BROADCASTADDRESS_EXT		-1
#define IVTKWINDOW_BROADCASTADDRESS_ALL		0
#define IVTKWINDOW_BROADCASTADDRESS_SURF	1
#define IVTKWINDOW_BROADCASTADDRESS_XSEC	2
#define IVTKWINDOW_BROADCASTADDRESS_VOLV	3
#define IVTKWINDOW_BROADCASTADDRESS_PART	4
#define IVTKWINDOW_BROADCASTADDRESS_VECT	5
#define IVTKWINDOW_BROADCASTADDRESS_TENS	6


class iVTKWindow
{

public:

	static void construct();
	static void destruct();
	static inline int getMaxWindowIndex(){ return fam->getMaxMemberIndex(); }
	static inline int getCurrentWindowIndex(){ return fam->getCurrentMemberIndex(); }
    static iVTK* getCurrentWindow() { return fam->getCurrentMember(); }
    static iVTK* getWindow(int i) { return fam->getMember(i); }
    static void setCurrentWindowIndex(int i);
	static int createWindow();
	static bool deleteWindow(int i);
	static void setEnabled(bool s);
	//
	//  helper function for changing iLimits settings (var=-1 means update all variables) 
	//
	static void broadcastVariableLimitsChange(int dataChannel, int var = -1, int address = IVTKWINDOW_BROADCASTADDRESS_ALL);
	static void broadcastExtentSettingsChange(int dataChannel, bool ext, int address = IVTKWINDOW_BROADCASTADDRESS_ALL);

private:

	static iFamily<iVTK> *fam;
    iVTKWindow(){}
	virtual ~iVTKWindow(){}

};

#endif  // IVTKWINDOW_H
