/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/**********************************************************************
*
*  IFRIT animation script class - maps commands to function calls
*
***********************************************************************/


#ifndef IANIMATORSCRIPT_H
#define IANIMATORSCRIPT_H


#include "iscript.h"


class iAnimator;

class iAnimatorScript: public iScript 
{

	friend class iObjectFactory;

public:

	static iAnimatorScript *New(iAnimator *);
	virtual ~iAnimatorScript();

	virtual void setDebugMode(bool s) { debugMode = s; }
	inline bool getDebugMode(){ return debugMode; }

protected:

	iAnimatorScript(iAnimator *m);
	//
	//  Temporary iValues
	//
	static iValue *valIS, *valFS, *valFP, *valVA3;
	static int counter;

	//
	//  Statement functions
	//
	static bool myCheckAbort(int lineInScript, int entryPointInteration, int entryPointIterationCount, int userCode);
	static void myShowLine(int lineInScript);

	//
	//  Render functions
	//
	static void Render(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void RenderAll(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void MultiRender(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  basic functions
	//
	static void Reset(iString *pErrorMessage);
	static void Load(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void Style(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void FramesPerFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void NumBlendedFrames(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void NumTransitionFrames(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void FlybySpeed(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void RotationPhi(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void RotationTheta(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void RotationRoll(iValue* v1, iScriptType::Assignment rel, iString *pErrorMessage);
	static void Scale(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void XsectionSpeed(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VarLo(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VarHi(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void AttLo(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void AttHi(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VecHi(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TenHi(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void CameraFocus(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void CameraPosition(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void CameraViewUp(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void CameraScale(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void Projection(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TimeLabel(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TimeLabelValue(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ColorBars(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void BoundingBox(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  Title page and logo
	//
	static void TitlePageFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TitlePageNumFrames(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TitlePageNumBlendedFrames(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LogoFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LogoOpacity(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LogoPosition(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  iVisualObject manipulation
	//
	static void SurfaceVar(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void SurfaceLevel(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void SurfaceOpacity(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void SurfaceNewInstance(iString *pErrorMessage);

	static void XsectionVar(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void XsectionDir(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void XsectionPos(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void XsectionNewInstance(iString *pErrorMessage);

	static void VolumeVar(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	static void ParticlesOpacity(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ParticlesDownsampleFactor(iValue *v0, iScriptType::Assignment rel, iString *pErrorMessage);

	static void MarkerPosition(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void MarkerSize(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void MarkerOpacity(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  Global variable functions
	//
	static iValue* GetMarkerPosition(int i);

	//
	//  VTK manipulation functions
	//
	static void SetCurrentVTK(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  File loading functions - for batch operations
	//
	static void LoadMeshFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LoadPartFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LoadVectFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LoadTensFile(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  Object showing/hiding functions - for batch operations
	//
	static void ShowSurface(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ShowXsection(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ShowVolume(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ShowParticles(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ShowVector(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ShowTensor(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	//
	//  iObject state assignment - undocumented for now
	//
	static void MarkerState(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ParticlesState(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void SurfaceState(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void TensorState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VectorState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VolumeState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void XsectionState(iValue* n, iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	static void AnimatorState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void DataReaderState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void LimitsState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void ParticlesSplitterState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);
	static void VTKState(iValue* v, iScriptType::Assignment rel, iString *pErrorMessage);

	bool debugMode;
	iAnimator *myAnimator;

};

#endif // IANIMATORSCRIPT_H
