/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICOLORBARS_H
#define ICOLORBARS_H

class vtkScalarBarActor;

class iPalette;
class iTextActor;
class vtkRenderer;

#include <vtkProp.h>
#include "ivtksource.h"


#define NLAB	10
#define NQUEUE	99


#define COLORBARS_PRIORITY_MANUAL0				-2
#define COLORBARS_PRIORITY_MANUAL1				-1
#define COLORBARS_PRIORITY_SURFACE_EXTERIOR		0
#define COLORBARS_PRIORITY_VOLUME				1
#define COLORBARS_PRIORITY_XSECTION				2
#define COLORBARS_PRIORITY_SURFACE_INTERIOR		3
#define COLORBARS_PRIORITY_VECTOR				4
#define COLORBARS_PRIORITY_TENSOR				5



class iColorBars: public vtkProp, private iVTKSource
{
	
public:
	
	static iColorBars *New(iVTK *m);
	
	virtual int RenderOverlay(vtkViewport*);
	virtual int RenderOpaqueGeometry(vtkViewport*);
	virtual int RenderTranslucentGeometry(vtkViewport *){ return 0; }
	
	virtual void ReleaseGraphicsResources(vtkWindow *win);

	virtual void setColor(float r, float g, float b);

	virtual void showBar(int priority, int v, int d, int p, bool s);

	virtual void setFontSize(int s);
	virtual void setFontType(int s);
	inline int getFontSize(){ return fontSize; }
	inline int getFontType(){ return fontType; }

	virtual void showAutomatic(bool);
	inline bool isAutomatic(){ return (pri[0]!=COLORBARS_PRIORITY_MANUAL0); }

	virtual void setManualBar(int bar, int v, int d, int p, bool s); 
	virtual void getManualBar(int bar, int &v, int &d, int &p, bool &s); 

	virtual void setSideOffset(float v);
	inline float getSideOffset(){ return xOff[1]; }

protected:
	
	iColorBars(iVTK *m);
	virtual ~iColorBars();
	
private:

	int fontSize, fontType;

	bool started;
	float scale;

	float height, width;
	float xOff[2], yOff;
	float xTextOff[2], xTitleOff[2];
	int jmax;

	int nqueue;
	int var[NQUEUE], pri[NQUEUE], dc[NQUEUE], count[NQUEUE], pal[NQUEUE];
	int varSave[2], dcSave[2], palSave[2];

	vtkMatrix4x4 *mat;

	vtkScalarBarActor *bar[2];
	iTextActor *titleActor[2];
	iTextActor *textActorBase[NLAB][2], *textActorPower[NLAB][2];

};

#endif // ICOLORBARS_H
