/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/



#include "iglobals.h"
#include "idialoghelp.h"

#include "ivtk.h"
#include "iqt.h"
#include "iqtwindow.h"
#include "iglobals.h"
#include "idatareader.h"

#include <qdragobject.h>
#include <qlistview.h>
#include <qmime.h>
#include <qsplitter.h>
#include <qtabwidget.h>
#include <qtextbrowser.h>

#ifndef I_VTK_VERSION_40
#include <vtkZLibDataCompressor.h>
#endif


void reportNullPointer(int);

#include <qimage.h>		//  These 3 includes are included in ihelp.h. We include them here
#include <qdict.h>		//  so that they do not actually included within the namespace
#include <qcstring.h>	//  protector

namespace iDialogHelp_Private
{
#include "ihelp.h"
};
using namespace iDialogHelp_Private;


void iDialogHelp::init()
{

	//
	//  Set splitter sizes
	//
	QValueList<int> sizes;
	sizes << 2 << 5;
	Splitter->setSizes(sizes);

	//ListView->setResizeMode(QListView::AllColumns);
	ListView->setColumnWidthMode(0,QListView::Maximum);
	
	this->loadData(embed_vec,embed_image_vec);
	this->addEntry(0,"vtkhelp");

}


void iDialogHelp::loadData(void* data0, void* images0)
{
	static const int hSize = sizeof(int); 
	int i;

	Embed *data = (Embed *)data0;
	EmbedImage *images = (EmbedImage *)images0;

#ifndef I_VTK_VERSION_40
	if(data != NULL)
	{
		//
		//  Load embedded data into the default source factory
		//
		union
		{
			int header;
			char c[hSize];
		};
		unsigned long srcLen, destLen;
		unsigned char *srcData, *destData;
		vtkZLibDataCompressor *dataCompressor = vtkZLibDataCompressor::New();
		if(dataCompressor == NULL) reportNullPointer(1030);
		
		for(i=0; data[i].name!=0; i++)
		{
			srcLen = data[i].size;
			srcData = (unsigned char*)data[i].data;
			
			memcpy(c,srcData,hSize);
			if(iDataReader::getEndinessOfMachine())
			{
				iDataReader::Swap4Bytes(c);
			}
			destLen = header;
			
			destData = new unsigned char[destLen+1];
			if(destData == NULL) reportNullPointer(1031);
			
			dataCompressor->Uncompress(srcData+hSize,srcLen-hSize,destData,destLen);
			destData[destLen] = 0;
			
			QMimeSourceFactory::defaultFactory()->setText(QString(data[i].name),QString((char *)destData));
			
			delete [] destData;
		}
		
		dataCompressor->Delete();
	}
#endif

	if(images != NULL)
	{
		//
		//  Load embedded images into the default source factory
		//
		for(i=0; images[i].name!=0; i++)
		{
			QMimeSourceFactory::defaultFactory()->setImage(QString(images[i].name),QImage((uchar*)images[i].data,images[i].width,images[i].height,images[i].depth,(QRgb*)images[i].colorTable,images[i].numColors,QImage::BigEndian));
		}
	}
}

void iDialogHelp::setSource(const QString &ref )
{
    TextBrowser->setSource(ref);
}


bool iDialogHelp::addEntry(QListViewItem *li, QString name)
{
    QString s0, s1;
    int i;
    
	const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data(name+".ihf");
	if(m == 0) return false;
 	if(!QTextDrag::decode(m,s0)) return false;
   
	i = s0.find("title=",0);
	if(i == 4)
	{
		s1 = s0.mid(i).section('"',1,1);
	}
	else
	{
		s1 = "UNTITLED ENTRY";
	}

    QListViewItem *ni = ListView->findItem(s1,0);
    //  Already in the list
    if(ni != 0) 
	{
		//
		//  Check whether this entry will be higher in the hierarchy than the existing one;
		//
	    QListViewItem *ti = ni;
		int depth1 = 0, depth2 = 1;
		while(ti->parent() != 0)
		{
			depth1++;
			ti = ti->parent();
		}
		ti = li;
		while(ti->parent() != 0)
		{
			depth2++;
			ti = ti->parent();
		}
		if(depth2 < depth1)
		{
			//
			//  New entry is higher
			//
			delete ni;
		}
		else
		{
			return true;
		}
    }

    if(li == 0)
	{
		ni = new QListViewItem(ListView,s1); 
		ni->setOpen(true);
	}
	else 
	{
		ni = new QListViewItem(li,s1);
		ni->setOpen(false);
	}

	dict.insert(s1,new QString(name));

	i = 0;
    while((i=s0.find("href=",i)) != -1)
    {
		i += 5;
		s1 = s0.mid(i);
		if(s1.section('"',0,0).isEmpty() && s1.mid(1,3)=="vtk" && s1.section('>',0,0).find("noshow",0)==-1)
		{
			s1 = s1.mid(1).section('.',0,0);
			this->addEntry(ni,s1);
		}
    }
    
    return true;
    
}


void iDialogHelp::viewFile(QListViewItem *v)
{
	static QString s1;
	if(v == 0) return;
	QString *s = dict[v->text(0)];
	s1 = (*s) + ".ihf";
	if(s != 0) TextBrowser->setSource(s1);
    
}


void iDialogHelp::reactToLink(const QString & s)
{
	int i = -1;
	if(s == "vtkwview.ihf") i = 0;
	if(s == "vtkwsurf.ihf") i = 1;
	if(s == "vtkwxsec.ihf") i = 2;
	if(s == "vtkwvolv.ihf") i = 3;
	if(s == "vtkwpart.ihf") i = 4;
	if(s == "vtkwvect.ihf") i = 5;
	if(s == "vtkwtens.ihf") i = 6;
	if(s == "vtkwdata.ihf") i = 7;
	if(i != -1) iQTWindow::getCurrentWindow()->TabWidget->setCurrentPage(i);

}


