/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


#include "iglobals.h"
#include "idialogpickextension.h"

#include "ipicker.h"
#include "ivtk.h"
#include "ivisualobjectobserver.h"
#include "idatareader.h"
#include "iuniformmeshdata.h"
#include "ipolygonaldata.h"
#include "imath.h"
#include "istreamline.h"
#include "ilimits.h"
#include "iqt.h"
#include "iqtwindow.h"
#include "ierror.h"
#include "iqtextension.h"

#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkPointLocator.h>
#include <vtkPointData.h>
#include <vtkPolyDataMapper.h>
#include <vtkMath.h>
#include <vtkCamera.h>

#include <qlabel.h>
#include <qlistview.h>
#include <qslider.h>


#define CALL_FUNCTION1(obj,fun,val) { obj->blockSignals(true); obj->fun(val); obj->blockSignals(false); } 


void iDialogPickExtension::init()
{
    picker = 0;
	Pick_PickVariableListView->setColumnWidthMode(0,QListView::Maximum);
	Pick_PickVariableListView->setColumnWidthMode(1,QListView::Maximum);
	Pick_PickVariableListView->setColumnWidthMode(2,QListView::Maximum);
	Pick_PickVariableListView->setSorting(-1);
}


void iDialogPickExtension::displayData(iPicker *p)
{
	static QString s1, s2;
	int i, j;
	vtkFloat pos1[3];
	double pos[3], extpos[3];

	picker = p;
    if(picker == 0) return;
	
	CALL_FUNCTION1(Pick_MarkerSizeSlider,setValue,round(100.0*picker->getVTK()->getPickedPointSize()));
	CALL_FUNCTION1(Pick_PickAccuracySlider,setValue,round(10.0*log10(picker->GetTolerance())));
	
	picker->GetPickPosition(pos1);
	for(j=0; j<3; j++) pos[j] = pos1[j];
	picker->getVTK()->transformToExternalCoordinate(3,pos,extpos);

	s1.setNum(extpos[0]);
	Pick_PosXTextLabel->setText(s1);

	s1.setNum(extpos[1]);
	Pick_PosYTextLabel->setText(s1);

	s1.setNum(extpos[2]);
	Pick_PosZTextLabel->setText(s1);

	Pick_ObjectTextLabel->setText("Unknown");
	Pick_PickVariableListView->clear();

	//
	//  Get the object info
	//
	vtkProp *obj = picker->GetProp();
	if(obj == 0) return;
	iVisualObjectObserver *obs = (iVisualObjectObserver *)obj->GetCommand(1);

	int otype, dtype;
	if(obs != 0)
	{
		otype = obs->getObjectType();
		dtype = obs->getDataType();
	}
	else
	{
		otype = IOBJECTTYPE_NONE;
		dtype = IDATATYPE_NONE;
	}
	//
	//  Display the object info
	//
	switch (otype)
	{
	case IOBJECTTYPE_SURF: { Pick_ObjectTextLabel->setText("Surface"); break; }
	case IOBJECTTYPE_XSEC: { Pick_ObjectTextLabel->setText("Xsection"); break; }
	case IOBJECTTYPE_VOLV: { Pick_ObjectTextLabel->setText("Volume"); break; }
	case IOBJECTTYPE_PART: { Pick_ObjectTextLabel->setText("Particles"); break; }
	case IOBJECTTYPE_VECT: { Pick_ObjectTextLabel->setText("Vector"); break; }
	case IOBJECTTYPE_TENS: { Pick_ObjectTextLabel->setText("Tensor"); break; }
	case IOBJECTTYPE_MARK: { Pick_ObjectTextLabel->setText("Marker"); break; }
	default:
		{
			if(iQTWindow::getCurrentWindow()->ext != NULL) iQTWindow::getCurrentWindow()->ext->setPickerObjectInfo(this,picker,otype);
		}
	}
	//
	//  Display the data info
	//
	vtkPointLocator *locator = vtkPointLocator::New();
	if(locator == 0) dtype = IDATATYPE_NONE; //else locator->BuildLocator();
	
	switch (dtype)
	{
	case IDATATYPE_MESH: 
		{ 
			int nvar = picker->getVTK()->getReader()->getLimits(0)->getNvar();
			//
			//  Do not need any locator - extract mesh data from the point location directly - and interpolate too.
			//  First find 8 neighbors
			//
			int dims[3];
			vtkFloat org[3], spa[3];
			float d1[3], d2[3];

			picker->getVTK()->getReader()->getMeshOutput()->GetDimensions(dims);
			picker->getVTK()->getReader()->getMeshOutput()->GetOrigin(org);
			picker->getVTK()->getReader()->getMeshOutput()->GetSpacing(spa);

			vtkIdType npoi = (vtkIdType)dims[0]*dims[1]*dims[2];
			if(npoi <= 0) break;

			int ijk1[3], ijk2[3];
			for(i=0; i<3; i++)
			{
				d1[i] = (pos[i]-org[i])/spa[i];
				ijk1[i] = (int)floor(d1[i]);
				d2[i] = d1[i] - ijk1[i];
				d1[i] = 1.0 - d2[i];

				while(ijk1[i] < 0) ijk1[i] += dims[i];  // in case it is extended 
				while(ijk1[i] >= dims[i]) ijk1[i] -= dims[i];

				ijk2[i] = ijk1[i] + 1;
				while(ijk2[i] < 0) ijk2[i] += dims[i];  // in case it is extended 
				while(ijk2[i] >= dims[i]) ijk2[i] -= dims[i]; // but not quite correct for non-periofic BC

			}
			//
			//  Interpolate mesh data keeping in mind that the data array is horizontal, not vertical
			//
			float *v = new float[nvar];
			float *ptr = (float *)picker->getVTK()->getReader()->getMeshOutput()->GetScalarPointer();
			for(j=0; j<nvar; j++)
			{
				v[j] = 
					*(ptr+ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2])+npoi*j)*d1[0]*d1[1]*d1[2] +
					*(ptr+ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2])+npoi*j)*d1[0]*d1[1]*d2[2] +
					*(ptr+ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2])+npoi*j)*d1[0]*d2[1]*d1[2] +
					*(ptr+ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2])+npoi*j)*d1[0]*d2[1]*d2[2] +
					*(ptr+ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2])+npoi*j)*d2[0]*d1[1]*d1[2] +
					*(ptr+ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2])+npoi*j)*d2[0]*d1[1]*d2[2] +
					*(ptr+ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2])+npoi*j)*d2[0]*d2[1]*d1[2] +
					*(ptr+ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2])+npoi*j)*d2[0]*d2[1]*d2[2];
			}
			//
			//  Make the correction for the surface
			//
			if(otype == IOBJECTTYPE_SURF)
			{
				vtkIdType pid = picker->GetPointId();
				if(picker->GetMapper()!=0 && ((vtkPolyDataMapper *)picker->GetMapper())->GetInput()!=0 && ((vtkPolyDataMapper *)picker->GetMapper())->GetInput()->GetPointData()!=0 && ((vtkPolyDataMapper *)picker->GetMapper())->GetInput()->GetPointData()->GetScalars()!=0)
				{
					vtkFloat *v1 = ((vtkPolyDataMapper *)picker->GetMapper())->GetInput()->GetPointData()->GetScalars()->GetTuple(pid);
					j = round(obs->getUserValue());
					if(j>0 && j<=nvar) v[j-1] = *v1;
				}
			}

			float vlin, vlog;
			unsigned int maxLen = 0;
			for(i=0; i<nvar; i++)
			{
				vlin = picker->getVTK()->getReader()->getLimits(0)->unstretchVar(v[i],i+1); 
				s2.setNum(vlin,'g',3);
				if(maxLen < s2.length()) maxLen = s2.length();
			}
			for(i=nvar-1; i>=0; i--)
			{
				vlin = picker->getVTK()->getReader()->getLimits(0)->unstretchVar(v[i],i+1); 
				vlog = log10(1.0e-30+fabs(vlin));
				s2.setNum(vlin,'g',3);
				if(s2.length() < maxLen) s2 += QString("                         ").left(maxLen-s2.length());
				s1 = s2;
				s1 += QString(" (");
				s2.sprintf("% 5.2f",vlog);
				s1 += s2;
				s1 += QString(" dex)");
				new QListViewItem(Pick_PickVariableListView,picker->getVTK()->getReader()->getLimits(0)->getVarName(i+1),s1);
			}

			delete [] v;

			break; 
		}
	case IDATATYPE_PART: 
		{ 
			int natt = picker->getVTK()->getReader()->getLimits(0)->getNatt();
			if(natt == 0)
			{
				dtype = IDATATYPE_NONE; break;
			}
			locator->SetDataSet(picker->getVTK()->getReader()->getParticlesOutput());
			vtkIdType pid = locator->FindClosestPoint(picker->GetPickPosition()); 
			if(pid<0 || pid>=picker->getVTK()->getReader()->getParticlesOutput()->GetNumberOfPoints()) 
			{
				dtype = IDATATYPE_NONE; break;
			}

			vtkFloat *v = picker->getVTK()->getReader()->getParticlesOutput()->GetPointData()->GetScalars()->GetTuple(pid);

			for(i=natt-1; i>=0; i--)
			{
				s1.setNum(v[i+1],'g',3);
				new QListViewItem(Pick_PickVariableListView,picker->getVTK()->getReader()->getLimits(0)->getAttName(i+1)+"  ",s1);
			}
			break; 
		}
	case IDATATYPE_VECT: 
		{ 
			//
			//  Do not need any locator - extract vector data from the point location directly - and interpolate too.
			//  First find 8 neighbors
			//
			int dims[3];
			vtkFloat org[3], spa[3];
			float v[3], vort[3], div[1];
			double posDouble[3];

			picker->getVTK()->getReader()->getVectorOutput()->GetDimensions(dims);
			picker->getVTK()->getReader()->getVectorOutput()->GetOrigin(org);
			picker->getVTK()->getReader()->getVectorOutput()->GetSpacing(spa);
			float *ptr = (float *)picker->getVTK()->getReader()->getVectorOutput()->GetPointData()->GetVectors()->GetVoidPointer(0);

			for(i=0; i<3; i++) posDouble[i] = pos[i];
			iStreamLine::getVector(posDouble,v,ptr,dims,org,spa,vort,div);

			float vortVal = 0.0;
			for(i=0; i<3; i++) vortVal += vort[i]*vort[i];
			s1.setNum(vortVal,'g',3);
			new QListViewItem(Pick_PickVariableListView,"Vorticity",s1);

			s1.setNum(div[0],'g',3);
			new QListViewItem(Pick_PickVariableListView,"Divergence",s1);

			s1 = "( ";
			for(i=0; i<3; i++)
			{
				s2.setNum(v[i],'g',3);
				s1 += s2;
				if(i < 2) s1 += " , ";
			}
			s1 += " )";
			new QListViewItem(Pick_PickVariableListView,"Vector components",s1);

			break; 
		}
	case IDATATYPE_TENS: 
		{ 
			//
			//  Do not need any locator - extract vector data from the point location directly - and interpolate too.
			//  First find 8 neighbors
			//
			int dims[3];
			vtkFloat org[3], spa[3];
			float d1[3], d2[3];

			picker->getVTK()->getReader()->getTensorOutput()->GetDimensions(dims);
			picker->getVTK()->getReader()->getTensorOutput()->GetOrigin(org);
			picker->getVTK()->getReader()->getTensorOutput()->GetSpacing(spa);

			int ijk1[3], ijk2[3];
			for(i=0; i<3; i++)
			{
				d1[i] = (pos[i]-org[i])/spa[i];
				ijk1[i] = (int)floor(d1[i]);
				d2[i] = d1[i] - ijk1[i];
				d1[i] = 1.0 - d2[i];

				while(ijk1[i] < 0) ijk1[i] += dims[i];  // in case it is extended 
				while(ijk1[i] >= dims[i]) ijk1[i] -= dims[i];

				ijk2[i] = ijk1[i] + 1;
				while(ijk2[i] < 0) ijk2[i] += dims[i];  // in case it is extended 
				while(ijk2[i] >= dims[i]) ijk2[i] -= dims[i]; // but not quite correct for non-periofic BC

			}
			//
			//  Interpolate vector data keeping in mind that the data array is vertical, not horizontal
			//
			float v[9];
			float *ptr = (float *)picker->getVTK()->getReader()->getTensorOutput()->GetPointData()->GetTensors()->GetVoidPointer(0);
			for(j=0; j<9; j++)
			{
				v[j] = 
					*(ptr+j+9*(ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2])))*d1[0]*d1[1]*d1[2] +
					*(ptr+j+9*(ijk1[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2])))*d1[0]*d1[1]*d2[2] +
					*(ptr+j+9*(ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2])))*d1[0]*d2[1]*d1[2] +
					*(ptr+j+9*(ijk1[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2])))*d1[0]*d2[1]*d2[2] +
					*(ptr+j+9*(ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk1[2])))*d2[0]*d1[1]*d1[2] +
					*(ptr+j+9*(ijk2[0]+dims[0]*(ijk1[1]+(vtkIdType)dims[1]*ijk2[2])))*d2[0]*d1[1]*d2[2] +
					*(ptr+j+9*(ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk1[2])))*d2[0]*d2[1]*d1[2] +
					*(ptr+j+9*(ijk2[0]+dims[0]*(ijk2[1]+(vtkIdType)dims[1]*ijk2[2])))*d2[0]*d2[1]*d2[2];
			}

			unsigned int maxLen = 0;
			for(j=0; j<3; j++)
			{
				for(i=0; i<3; i++)
				{
					s2.setNum(v[i+3*j],'g',3);
					if(maxLen < s2.length()) maxLen = s2.length();
				}
			}
			s1 = "";
			for(j=0; j<3; j++)
			{
				s1 = " ";
				for(i=0; i<3; i++)
				{
					s2.setNum(v[i+3*j],'g',3);
					if(s2.length() < maxLen) s2 += QString("                         ").left(maxLen-s2.length());
					s1 += s2;
					s1 += "  ";
				}
				if(j == 1) new QListViewItem(Pick_PickVariableListView,"Tensor components",s1); else new QListViewItem(Pick_PickVariableListView,"",s1);
			}
			//
			// Compute the maximum and minimum eigenvalues
			//
			float eigmax = 0.0, eigmin = 1.0e35;
			float *mat[3], eig[3], *eiv[3];
			float mat0[3], mat1[3], mat2[3];
			float eiv0[3], eiv1[3], eiv2[3];
			// set up working matrices
			mat[0] = mat0; mat[1] = mat1; mat[2] = mat2; 
			eiv[0] = eiv0; eiv[1] = eiv1; eiv[2] = eiv2; 
			mat[0][0] = *(v+0); mat[0][1] = *(v+1); mat[0][2] = *(v+2); 
			mat[1][0] = *(v+3); mat[1][1] = *(v+4); mat[1][2] = *(v+5); 
			mat[2][0] = *(v+6); mat[2][1] = *(v+7); mat[2][2] = *(v+8); 
			vtkMath::Jacobi(mat,eig,eiv);
			if(eig[0] > eigmax) eigmax = eig[0];
			if(eig[1] > eigmax) eigmax = eig[1];
			if(eig[2] > eigmax) eigmax = eig[2];
			if(eig[0] < eigmin) eigmin = eig[0];
			if(eig[1] < eigmin) eigmin = eig[1];
			if(eig[2] < eigmin) eigmin = eig[2];

			s1.setNum(eigmax,'g',3);
			new QListViewItem(Pick_PickVariableListView,"Maximum eigenvalue",s1);

			s1.setNum(eigmin,'g',3);
			new QListViewItem(Pick_PickVariableListView,"Minimum eigenvalue",s1);

			break; 
		}
	default:
		{
			if(iQTWindow::getCurrentWindow()->ext != NULL) iQTWindow::getCurrentWindow()->ext->setPickerDataInfo(this,picker,dtype);
		}
	}

	if(locator != 0) locator->Delete();

}


void iDialogPickExtension::updateMakeCameraFocalPoint()
{
    if(picker != 0) 
	{
		int n = round(2.0/picker->getVTK()->getRenderer()->GetLastRenderTimeInSeconds());
		if(n > 60) n = 60;
		if(n < 10) n = 0;
		picker->getVTK()->getInteractor()->SetNumberOfFlyFrames(n);
		picker->getVTK()->getInteractor()->FlyTo(picker->GetRenderer(),picker->GetPickPosition());
	}
}


void iDialogPickExtension::updatePlaceMarker()
{
    if(picker != 0) 
	{
		vtkFloat *x = picker->GetPickPosition();
		double xi[3];
		for(int j=0; j<3; j++) xi[j] = x[j];
		iQTWindow::getCurrentWindow()->placeNewMarker(xi);
	}
}


void iDialogPickExtension::updateCenterOnScreen()
{
	int j;
    if(picker != 0) 
	{
		vtkFloat *x = picker->GetPickPosition();
		double xi[3];
		for(j=0; j<3; j++) xi[j] = x[j];
		vtkCamera *cam = picker->getVTK()->getRenderer()->GetActiveCamera();
		double cf[3], cp[3];
		cam->GetPosition(cp);
		cam->GetFocalPoint(cf);
		for(j=0; j<3; j++) cp[j] += (xi[j]-cf[j]);
		cam->SetFocalPoint(xi);
		cam->SetPosition(cp);
		picker->getVTK()->render(true);
	}
}


void iDialogPickExtension::updateMarkerSize(int s)
{
    if(picker != 0) 
	{
		picker->getVTK()->setPickedPointSize(0.01*s);
	}
}


void iDialogPickExtension::updateMarkerSizeFinal()
{
    if(picker != 0) 
	{
		picker->getVTK()->render(false);
	}

}


void iDialogPickExtension::updatePickAccuracy(int s)
{
    if(picker != 0) 
	{
		picker->SetTolerance(pow(10.0,0.1*s));
	}
}


