/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
*
*  Class containing IFRIT environment variables
*
****************************************************************************/

#include "ienvironment.h"
#include <stdlib.h>

#include "iobjectfactory.h"


iEnvironment* iEnvironment::me = 0;


void reportNullPointer(int);


void iEnvironment::construct()
{
	if(me == 0)
	{
		me = (iEnvironment *)iObjectFactory::createEnvironment();
		if(me == 0) reportNullPointer(2604);
	}
}


void iEnvironment::destruct()
{
	if(me != 0) delete me;
}


iEnvironment::iEnvironment()
{
	char *e;
	
	IFRIT_RENDER = 0;

	errorDestination = 1;
	errorFirstSymbol = 0;
	errorFirstString = 0;
	//    
	//  Read the environment here    
	//    
    e = getenv("IFRIT_DIR");
    if(e != 0) IFRIT_DIR = iString(e); 
	
    e = getenv("IFRIT_DATA_DIR");
    if(e != 0) IFRIT_DATA_DIR = iString(e); 
	
    e = getenv("IFRIT_MESH_DATA_DIR");
    if(e != 0) IFRIT_MESH_DATA_DIR = iString(e); else IFRIT_MESH_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_PARTICLE_DATA_DIR");
    if(e != 0) IFRIT_PART_DATA_DIR = iString(e); else IFRIT_PART_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_VECTOR_DATA_DIR");
    if(e != 0) IFRIT_VECT_DATA_DIR = iString(e); else IFRIT_VECT_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_TENSOR_DATA_DIR");
    if(e != 0) IFRIT_TENS_DATA_DIR = iString(e); else IFRIT_TENS_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_IMAGE_DIR");
    if(e != 0) IFRIT_IMAGE_DIR = iString(e); 
	
    e = getenv("IFRIT_SCRIPT_DIR");
    if(e != 0) IFRIT_SCRIPT_DIR = iString(e); else IFRIT_SCRIPT_DIR = IFRIT_DIR;
	
    e = getenv("IFRIT_PALETTE_DIR");
    if(e != 0) IFRIT_PALETTE_DIR = iString(e); else IFRIT_PALETTE_DIR = IFRIT_DIR;
	
    e = getenv("IFRIT_RECORD_DIR");
    if(e != 0) IFRIT_RECORD_DIR = iString(e); else IFRIT_RECORD_DIR = IFRIT_DIR;
	
}


void iEnvironment::set_IFRIT_DATA_DIR(char *s)
{
	char *e;

    IFRIT_DATA_DIR = iString(s); 

    e = getenv("IFRIT_MESH_DATA_DIR");
    if(e != 0) IFRIT_MESH_DATA_DIR = iString(e); else IFRIT_MESH_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_PARTICLE_DATA_DIR");
    if(e != 0) IFRIT_PART_DATA_DIR = iString(e); else IFRIT_PART_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_VECTOR_DATA_DIR");
    if(e != 0) IFRIT_VECT_DATA_DIR = iString(e); else IFRIT_VECT_DATA_DIR = IFRIT_DATA_DIR;
	
    e = getenv("IFRIT_TENSOR_DATA_DIR");
    if(e != 0) IFRIT_TENS_DATA_DIR = iString(e); else IFRIT_TENS_DATA_DIR = IFRIT_DATA_DIR;

	this->extSet_IFRIT_DATA_DIR(s);
}


iString iEnvironment::getFileName(const char *envDir, const char *fName)
{

	iString ed;

	if(strcmp(envDir,"DIR") == 0) ed = IFRIT_DIR;

	if(strcmp(envDir,"DATA_DIR") == 0) ed = IFRIT_DATA_DIR;
	if(strcmp(envDir,"MESH_DATA_DIR") == 0) ed = IFRIT_MESH_DATA_DIR;
	if(strcmp(envDir,"PART_DATA_DIR") == 0) ed = IFRIT_PART_DATA_DIR;
	if(strcmp(envDir,"VECT_DATA_DIR") == 0) ed = IFRIT_VECT_DATA_DIR;
	if(strcmp(envDir,"TENS_DATA_DIR") == 0) ed = IFRIT_TENS_DATA_DIR;

	if(strcmp(envDir,"IMAGE_DIR") == 0) ed = IFRIT_IMAGE_DIR;
	if(strcmp(envDir,"SCRIPT_DIR") == 0) ed = IFRIT_SCRIPT_DIR;
	if(strcmp(envDir,"PALETTE_DIR") == 0) ed = IFRIT_PALETTE_DIR;

	if(ed.isEmpty())
	{
		return this->extGetFileName(envDir,fName);
	} 
	else 
	{
		return ed+"/"+fName;
	}

}




