/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
*
*  Class containing IFRIT environment variables
*
****************************************************************************/
#ifndef IENVIRONMENT_H
#define IENVIRONMENT_H


#include "istring.h"


class iEnvironment
{
	
	friend class iObjectFactory;

public:
	
	static void construct();
	static void destruct();

	inline static iEnvironment* getInstance(){ return me; }

	inline int get_IFRIT_RENDER(){ return IFRIT_RENDER; }
	inline iString get_IFRIT_DIR(){ return IFRIT_DIR; }
	inline iString get_IFRIT_DATA_DIR(){ return IFRIT_DATA_DIR; }
	inline iString get_IFRIT_MESH_DATA_DIR(){ return IFRIT_MESH_DATA_DIR; }
	inline iString get_IFRIT_PART_DATA_DIR(){ return IFRIT_PART_DATA_DIR; }
	inline iString get_IFRIT_VECT_DATA_DIR(){ return IFRIT_VECT_DATA_DIR; }
	inline iString get_IFRIT_TENS_DATA_DIR(){ return IFRIT_TENS_DATA_DIR; }
	inline iString get_IFRIT_IMAGE_DIR(){ return IFRIT_IMAGE_DIR; }
	inline iString get_IFRIT_SCRIPT_DIR(){ return IFRIT_SCRIPT_DIR; }
	inline iString get_IFRIT_PALETTE_DIR(){ return IFRIT_PALETTE_DIR; }
	inline iString get_IFRIT_RECORD_DIR(){ return IFRIT_RECORD_DIR; }
	
	virtual void set_IFRIT_DATA_DIR(char *s);
	virtual void extSet_IFRIT_DATA_DIR(char *s){}

	virtual iString getFileName(const char *envDir, const char *fName); 
	virtual iString extGetFileName(const char *envDir, const char *fName){ return iString(fName); } 

	virtual int whereErrorMessagesGo(){ return errorDestination; }
	virtual void directErrorMessagesToNowhere(){ errorDestination = 0; }
	virtual void directErrorMessagesToLog(){ errorDestination = 1; }
	virtual void directErrorMessagesToWindow(){ errorDestination = 2; }
	
	virtual void setErrorMessageFirstSymbol(int n){ errorFirstSymbol = n; }
	virtual int getErrorMessageFirstSymbol(){ return errorFirstSymbol; }
	virtual void setErrorMessageFirstString(char *s){ errorFirstString = s; }
	virtual char *getErrorMessageFirstString(){ return errorFirstString; }

protected:
	
	static iEnvironment *me;
	iEnvironment();
	virtual ~iEnvironment(){}
	
	iString IFRIT_DIR;
	iString IFRIT_DATA_DIR;
	iString IFRIT_MESH_DATA_DIR;
	iString IFRIT_PART_DATA_DIR;
	iString IFRIT_VECT_DATA_DIR;
	iString IFRIT_TENS_DATA_DIR;
	iString IFRIT_IMAGE_DIR;
	iString IFRIT_SCRIPT_DIR;
	iString IFRIT_PALETTE_DIR;
	iString IFRIT_RECORD_DIR;
	int IFRIT_RENDER;

	int errorDestination;
	int errorFirstSymbol;
	char *errorFirstString;

};

#endif // IENVIRONMENT_H
