/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IFAMILY_H
#define IFAMILY_H

class iVTK;

template<class T>
class iFamily 
{

public:

	iFamily(iVTK *m = 0);
	virtual ~iFamily();
	inline int getMaxMemberIndex(){ return max; }
	inline int getCurrentMemberIndex(){ return cur; }
    T* getCurrentMember() { return memlist[cur]; }
    T* getMember(int i) { if(i>=0 && i<=max) return memlist[i]; else return 0; }
    void setCurrentMemberIndex(int i) { if(i>=0 && i<=max) cur = i; }
	virtual int createMember();
	virtual bool deleteMember(int i);

protected:

	T* New();
	T **memlist; 
	int cur, max, maxMax;
	iVTK *myVTK;

};


template<class T>
iFamily<T>::iFamily(iVTK *m)
{
	int i;

	myVTK = m;

	cur = max = 0;
	maxMax = 100;

	memlist = new T*[maxMax];
	if(memlist == 0) reportNullPointer(2501);

	memlist[0] = New();
	if(memlist[0] == 0) reportNullPointer(2502);
    for(i=1; i<maxMax; i++)  memlist[i] = 0;

}


template<class T>
iFamily<T>::~iFamily()
{
	int i;
    for(i=0; i<=max; i++) delete memlist[i];
	delete [] memlist;
}


template<class T>
T* iFamily<T>::New()
{
	return T::New(myVTK);
}


template<class T>
int iFamily<T>::createMember()
{

	if(max+1 == maxMax)
	{
		//
		//  Extend array if too small
		//
		maxMax += 100;
		T** newMemlist = new T*[maxMax];
		if(newMemlist == 0) return -1;

		int i;
		for(i=0; i<=max; i++) newMemlist[i] = memlist[i];
		delete [] memlist;
		memlist = newMemlist;

	}

	max++;
	memlist[max] = New();
	if(memlist[max] == 0) { max--; return -1; }
	return max;

}


template<class T>
bool iFamily<T>::deleteMember(int i)
{
	int j;

	if(i>=0 && i<=max && max>0)
	{
		delete memlist[i];
		for(j=i; j<max; j++) memlist[j] = memlist[j+1];
		memlist[max] = 0;
		if(cur > i) cur--;
		max--;
		if(cur > max) cur = max;
		return true;
    }
	else return false;

}


#endif // IFAMILY_H
