/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "ifunctionparser.h"

iFunctionParser* iFunctionParser::New()
{
	return new iFunctionParser;
}


int iFunctionParser::checkSyntax(const char *s)
{
	int result;

	if(s==0 || *s==0) return 0;

	this->SetFunction(s);

	this->RemoveSpaces();
	
	result = this->CheckSyntax();
	if (!result)
    {
		return 1;
    }
	
	result = this->BuildInternalFunctionStructure();
	if (!result)
    {
		vtkErrorMacro("Parse: Error creating internal structure for parse string");
		return 1;
    }
	
	// need to make sure that the ambiguous operators are correct
	// - scalar/vector +
	// - scalar/vector -
	// - scalar/vector unary minus
	// - * (2 scalars) or scalar multiple (scalar, vector)
	result = this->DisambiguateOperators();
	if (!result)
    {
		vtkErrorMacro("Parse: Error deciding between ambiguous operators");
		return 1;
    }

	return 0;
  
}
