/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IMEASURINGBOXINTERACTORSTYLE_H
#define IMEASURINGBOXINTERACTORSTYLE_H

#include "iglobals.h"
#include <vtkInteractorStyleTrackballActor.h>

class iMeasuringBox;


class iMeasuringBoxInteractorStyle: virtual public vtkInteractorStyleTrackballActor 
{
	
public:
	
	static iMeasuringBoxInteractorStyle *New();
	
	void SetMeasuringBox(iMeasuringBox *b){ if(b) mBox = b; }
	void FindPickedActor(int x, int y);

#ifndef I_VTK_VERSION_40

	void UniformScale();
	void Pan();
	void OnChar();
	void Rotate();

#else

	void PanInScreen(int x, int y, int oldX, int oldY);
	void PanXYZ(int x, int y, int oldX, int oldY);
	void OnChar(int ctrl, int shift, char keycode, int repeatcount);
//
//  These functions need to be copied from vtkInteractorStyleTrackballActor
//  because they are not declared virtual - BAD DESIGN!
//
	void OnMouseMove(int ctrl, int shift, int x, int y) ;
	void OnLeftButtonDown(int ctrl, int shift, int x, int y);
	void OnMiddleButtonDown(int ctrl, int shift, int x, int y);
	void OnRightButtonDown(int ctrl, int shift, int x, int y);

#endif

protected:
	
	iMeasuringBoxInteractorStyle(){ mBox = 0; }
	~iMeasuringBoxInteractorStyle(){}
	
private:

	iMeasuringBox *mBox;

};

#endif // IMEASURINGBOXINTERACTORSTYLE_H
