/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iobject.h"


#ifdef _DEBUG
void __deb()
{
	int q = 0;
}
#endif


iString iObject::slash = "!AKhcOTreHC!";


iObject::iObject(iVTK *m) : iVTKSource(m)
{
}


iObject::~iObject()
{
}


void iObject::copyState(iObject *p)
{
	iString s;
	//
	//  Read the parameters
	//
	p->packState(s);
	//
	//  Set the parameters of the new instance
	//
	this->unpackState(s);
}


//
//  Packing helpers
//
void iObject::packValue(iString &s, iString key, int* val, int num)
{
	int i;
	s += " " + key;
	for(i=0; i<num; i++) s += "/" + iString::number(val[i]);
	s += "/";
}


void iObject::packValue(iString &s, iString key, bool* val, int num)
{
	int i;
	s += " " + key;
	for(i=0; i<num; i++) s += "/" + iString::number(val[i]?1:0);
	s += "/";
}


void iObject::packValue(iString &s, iString key, float* val, int num)
{
	int i;
	s += " " + key;
	for(i=0; i<num; i++) s += "/" + iString::number(val[i]);
	s += "/";
}


void iObject::packValue(iString &s, iString key, double* val, int num)
{
	int i;
	s += " " + key;
	for(i=0; i<num; i++) s += "/" + iString::number(val[i]);
	s += "/";
}


void iObject::packValue(iString &s, iString key, iColor* val, int num)
{
	int i;
	s += " " + key;
	for(i=0; i<num; i++) s += "/" + iString::number(val[i].red()) + "." + iString::number(val[i].green()) + "." + iString::number(val[i].blue());
	s += "/";
}


void iObject::packValue(iString &s, iString key, iString* val, int num)
{
	int i;
	iString s1;
	s += " " + key;
	for(i=0; i<num; i++) 
	{
		s1 = val[i];
		s1.replace("/",slash);
		s += "/" + s1;
	}
	s += "/";
}


//
//  Unpacking helpers
//
bool iObject::unpackValue(iString s, iString key, int* val, int num)
{
	bool ok;
	int ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		int* v = new int[num];
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			v[i] = s.mid(ind).section('/',i+1,i+1).toInt(&ok);
		}
		if(ok) memcpy(val,v,num*sizeof(int));
		delete [] v;
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}


bool iObject::unpackValue(iString s, iString key, bool* val, int num)
{
	bool ok;
	int ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		bool* v = new bool[num];
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			v[i] = (s.mid(ind).section('/',i+1,i+1).toInt(&ok) != 0);
		}
		if(ok) memcpy(val,v,num*sizeof(bool));
		delete [] v;
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}


bool iObject::unpackValue(iString s, iString key, float* val, int num)
{
	bool ok;
	int ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		float* v = new float[num];
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			v[i] = s.mid(ind).section('/',i+1,i+1).toFloat(&ok);
		}
		if(ok) memcpy(val,v,num*sizeof(float));
		delete [] v;
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}


bool iObject::unpackValue(iString s, iString key, double* val, int num)
{
	bool ok;
	int ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		double* v = new double[num];
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			v[i] = s.mid(ind).section('/',i+1,i+1).toDouble(&ok);
		}
		if(ok) memcpy(val,v,num*sizeof(double));
		delete [] v;
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}


bool iObject::unpackValue(iString s, iString key, iColor* val, int num)
{
	bool ok, ok1;
	iString s1;
	int r, g, b, ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		iColor* v = new iColor[num];
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			s1 = s.mid(ind).section('/',i+1,i+1);
			r = s1.section('.',0,0).toInt(&ok1); ok &= ok1;
			g = s1.section('.',1,1).toInt(&ok1); ok &= ok1;
			b = s1.section('.',2,2).toInt(&ok1); ok &= ok1;
			v[i] = iColor(r,g,b);
		}
		if(ok) memcpy(val,v,num*sizeof(iColor));
		delete [] v;
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}


bool iObject::unpackValue(iString s, iString key, iString* val, int num)
{
	bool ok;
	int ind = s.find(key+"/");
	if(ind >=0)
	{
		int i;
		ok = true;
		for(i=0; ok && i<num; i++)
		{
			val[i] = s.mid(ind).section('/',i+1,i+1);
			val[i].replace(slash,"/");
		}
	}
	else ok = false;
#ifdef _DEBUG
	if(!ok) __deb();
#endif
	return ok;
}

