/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "iobjectfactory.h"

#include <string.h>

#include "iobject.h"
#include "ivtk.h"
#include "ienvironment.h"
#include "imarker.h"
#include "iparticles.h"
#include "isurface.h"
#include "itensor.h"
#include "ivector.h"
#include "ivolume.h"
#include "ixsection.h"
#include "idatareader.h"
#include "ianimatorscript.h"
#include "idialogvariablesexplorer.h"

#if EXTENSION == 1
#include "hobjects.h"
#endif


void reportNullPointer(int);


iObject* iObjectFactory::createObject(char* s, iVTK *vtk)
{
	//
	//  Other objects
	//
	if(strcmp(s,"DataReader") == 0) 
	{
#if EXTENSION == 1
		return new hDataReader(vtk);
#else
		return new iDataReader(vtk);
#endif
	}

	//
	//  Visual objects
	//
	if(strcmp(s,"Particles") == 0) 
	{
#if EXTENSION == 1
		return new hParticles(vtk);
#else
		return new iParticles(vtk);
#endif
	}

	if(strcmp(s,"Surface") == 0) 
	{
#if EXTENSION == 1
		return new hSurface(vtk);
#else
		return new iSurface(vtk);
#endif
	}

	if(strcmp(s,"Tensor") == 0) 
	{
#if EXTENSION == 1
		return new hTensor(vtk);
#else
		return new iTensor(vtk);
#endif
	}

	if(strcmp(s,"Vector") == 0) 
	{
#if EXTENSION == 1
		return new hVector(vtk);
#else
		return new iVector(vtk);
#endif
	}

	if(strcmp(s,"Volume") == 0) 
	{
#if EXTENSION == 1
		return new hVolume(vtk);
#else
		return new iVolume(vtk);
#endif
	}

	if(strcmp(s,"Xsection") == 0) 
	{
#if EXTENSION == 1
		return new hXsection(vtk);
#else
		return new iXsection(vtk);
#endif
	}

#if EXTENSION == 1
	if(strcmp(s,"HARTMesh") == 0) 
	{
		return new hMesh(vtk);
	}
#endif

	reportNullPointer(0001);
	return 0;

}


iVTK* iObjectFactory::createVTK()
{

#if EXTENSION == 1
	return new hVTK;
#else
	return new iVTK;
#endif

}


iQTExtension* iObjectFactory::createQTExtension(QWidget *parent)
{

#if EXTENSION == 1
	return new hQTExtension(parent,"hQTExtension");
#else
	return 0;
#endif

}


iEnvironment* iObjectFactory::createEnvironment()
{

#if EXTENSION == 1
	return new hEnvironment;
#else
	return new iEnvironment;
#endif

}


iAnimatorScript* iObjectFactory::createAnimatorScript(iAnimator *m)
{

#if EXTENSION == 1
	return new hAnimatorScript(m);
#else
	return new iAnimatorScript(m);
#endif

}


iDialogVariablesExplorer* iObjectFactory::createVariablesExplorer()
{

#if EXTENSION == 1
	return new hDialogVariablesExplorer;
#else
	return new iDialogVariablesExplorer;
#endif

}
