/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Header file for classes that support GUI data structures. They are 
created to minimize interaction berween GUI and VTK. 
*/

#ifndef IPARTICLES_H
#define IPARTICLES_H

class vtkPolyData;
class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class vtkProperty;
class vtkLookupTable;

class iPiecewiseFunction;
class iParticlesDataConverter;
class iPolygonalDataExtender;
class iHistogramMaker;
class iParticlesConnector;
class iParticlesSplitter;

#include "ivisualobject.h"
#include "icolor.h"


class iParticles : public iVisualObject
{
	
	friend class iObjectFactory;

public:
	
	static iParticles* New(iVTK *m = 0);
	virtual ~iParticles();
	
	inline vtkLODActor* getActor(){ return particlesActor; }
	inline int getType(){ return type; }
	inline int getAttToColor(){ return attColor; }
	inline int getAttToSize(){ return attSize; }
	inline int getPal(){ return pal; }
	inline float getOpacity(){ return opa; }
	inline float getFixedSize(){ return size; }
	inline bool getLogScaleToColor(){ return logscaleToColor; }
	inline bool getLogScaleToSize(){ return logscaleToSize; }
	inline bool getAttSizeDirect(){ return attSizeDirect; }
	inline double getAttSizeExtraFactor(){ return attSizeExtraFactor; }
	inline float getLineWidth(){ return lineWidth; }
	inline iPiecewiseFunction* getSizeFunction(){ return sif; }
	inline iParticlesDataConverter* getConverter(){ return particlesDataConverter; }
	inline iPolygonalDataExtender* getExtender(){ return particlesExtender; }
	inline iParticlesConnector* getConnector(){ return particlesConnector; }
	inline int getParticlesSplitterPiece(){ return myPiece; }
	inline vtkLookupTable* getColorLookupTable(){ return colorLookupTable; }
	inline iHistogramMaker *getHistogramMaker(){ return histogramMaker; }

	double getAttSizeBasicScale();

	virtual void setType(int t);
	virtual void setAttToColor(int a);
	virtual void setAttToSize(int a);
	virtual void setPal(int p);
	virtual void setOpacity(float s);
	virtual void setFixedSize(float s);
	virtual void setLogScaleToColor(bool s);
	virtual void setLogScaleToSize(bool s);
	virtual void setAttSizeDirect(bool s);
	virtual void setAttSizeExtraFactor(double f);
	virtual void setLineWidth(int s);

	virtual void setParticlesSplitterPiece(int n);

	virtual void updateColorLookupTable();

	virtual void show(bool s);
	virtual void reset();
	virtual void connectSplitter(int dc, int ds);
	
	inline iColor getColor(){ return color; }
	virtual void setColor(iColor c);
	
	inline bool isShaded(){ return shaded; }
	
	virtual void setShade(bool v);
	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);

	virtual void showClipPlane(bool s);
	virtual void showColorBars(bool){ }

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

	inline iParticlesSplitter *getParticlesSplitter(){ return mySplitter; }

protected:
	
	iParticles(iVTK *m = 0);

	iParticlesSplitter *mySplitter;
	int myPiece, mySplitterDataChannel, mySplitterDataStream;

	int attColor, attSize;
	bool attSizeDirect;
	double attSizeExtraFactor;
	iColor color;
	int type;
	int pal;
	float opa;
	iPiecewiseFunction* sif;
	float size;
	bool logscaleToColor, logscaleToSize;
	int lineWidth;

	bool shaded;
	bool keepPoint;
	//
	//  VTK members
	//
	vtkLODActor *particlesActor;	
	vtkPolyDataMapper *particlesMapper;
	vtkProperty *particlesProperty;
	vtkLookupTable *colorLookupTable;

	iParticlesDataConverter *particlesDataConverter;
	iPolygonalDataExtender *particlesExtender;
	iParticlesConnector *particlesConnector;

	iHistogramMaker *histogramMaker;
	
};

#endif // IPARTICLES_H
 
