/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iprogressbar.h"

//
//  This is thread-safe
//
#include <qapplication.h>


iProgressBar::iProgressBar(QWidget * parent, const char * name, WFlags f) : QProgressBar(parent,name,f)
{
	this->setCenterIndicator(true);
	percentage = 0;
	mode = 0;
}


void iProgressBar::setProgress(int progress)
{
	if(progress < -9) 
	{
		mode = progress; 
#ifdef QT_THREAD_SUPPORT
		qApp->lock();
#endif
		QProgressBar::reset();
#ifdef QT_THREAD_SUPPORT
		qApp->unlock();
#endif
	}
	else 
	{
#ifdef QT_THREAD_SUPPORT
		qApp->lock();
#endif
		QProgressBar::setProgress(progress);
#ifdef QT_THREAD_SUPPORT
		qApp->unlock();
#endif
	}
}


void iProgressBar::reset()
{
	mode = 0;
	QProgressBar::reset();
}


bool iProgressBar::setIndicator(QString &indicator, int progress, int totalSteps)
{
    if(totalSteps == 0)
	{
		return false;
	}

    if(progress < 0) 
	{
		indicator = QString("");
		return true;
    } 
	else 
	{
		int np = progress * 100 / totalSteps;
		if(np != percentage) 
		{
			percentage = np;
			switch (mode)
			{
			case -10: { indicator = QString("Reading..."); break; }
			case -11: { indicator = QString("Projecting..."); break; }
			case -12: { indicator = QString("Rendering..."); break; }
			case -13: { indicator = QString("Writing..."); break; }
			default: indicator.sprintf("%d%%",np);
			}
			return true;
		}
		else 
		{
			return false;
		}
    }

}
