/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iqt.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"
#include "iqtextension.h"
#include "iqtdefs.h"
#include "iqt_volv.h"
#include "iqt_view.h"

#include "ihistogrammaker.h"
#include "imath.h"
#include "ipiecewisefunction.h"
#include "ivolume.h"
#include "ilimits.h"
#include "ipalette.h"
#include "idatareader.h"
#include "ierror.h"

#include <qaction.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>

#include <vtkRenderer.h>
#include <vtkCamera.h>


#define CURRENT_LIMITS	iVTKWindow::getCurrentWindow()->getReader()->getLimits(CURRENT_VOLUME->getDataChannel())


//
// *********************************************************************************
//
//  
//   Volume myQT->rendering panel widgets
//
//
// *********************************************************************************
//
void iQT_Volv::init()
{
	
	myQT = (iQT *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	if(strcmp(myQT->name(),"iQT") != 0)
	{
		iQTWindow::getCurrentWindow()->popupError("Incorrect parenting in Tab Pages",IFRITERROR_INCORRECT_PARENTING_IN_TABS);
		exit(1);
	}

    cpVolv_Opaci_Function = 0;
	
    iVTKWindow::getCurrentWindow()->setWindowSizeButtonGroup(Volv_Field_WindowSizeBox);
	//
	//  Make sliders look better
	//
	LayoutVolvMaterial->setStretchFactor(Volv_Paint_MaterialGroupBox,3);
	LayoutVolvMaterial->addStretch(1);
	
	LayoutVolvResample->setStretchFactor(Volv_Advan_ResampleGroupBox,3);
	LayoutVolvResample->addStretch(1);
	
}


void iQT_Volv::doRender()
{
	myQT->doRender();
}


void iQT_Volv::updateVolv_Widgets()
{

    int v;
    float f;
	
    v = CURRENT_VOLUME->getVar();
	//
	//  Variable names
	//
	Volv_Field_PrimaryFieldVar1->setText(CURRENT_LIMITS->getVarName(1));
    Volv_Field_PrimaryFieldVar2->setText(CURRENT_LIMITS->getVarName(2));
    Volv_Field_PrimaryFieldVar3->setText(CURRENT_LIMITS->getVarName(3));
	//
	//  Main panel widgets
	//    
	myQT->TabWidgetView->updateSwitchesVolv();

    CALL_FUNCTION1(Volv_Field_PrimaryFieldBox,setButton,v-1);
	
	//    for(int i=0; i<Volv_Field_SecondaryFieldBox->count(); i++) Volv_Field_SecondaryFieldBox->find(i)->setEnabled(true);
	//    Volv_Field_SecondaryFieldBox->find(v)->setEnabled(false);
	//    if(Volv_Field_SecondaryFieldBox->id(Volv_Field_SecondaryFieldBox->selected()) ==v ) Volv_Field_SecondaryFieldBox->setButton(0);
	
    CALL_FUNCTION1(Volv_Field_MethodBox,setButton,CURRENT_VOLUME->getMode());
    if(CURRENT_VOLUME->getMode()==IVOLUME_MODE_VOLUMEPRO && myQT->TabWidgetView->View_Volv->isChecked()) 
	{
		myQT->TabWidgetView->View_Projection->setEnabled(false);
		if(myQT->TabWidgetView->View_Projection->id(myQT->TabWidgetView->View_Projection->selected()) == 1) 
		{
			CALL_FUNCTION1(myQT->TabWidgetView->View_Projection,setButton,0);
			iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->ParallelProjectionOn(); 
			myQT->popupInfo("VolumePro board only suports the Orthogonal projection.\n Setting the projection to Orthogonal.\n");
		}
    } else myQT->TabWidgetView->View_Projection->setEnabled(true);
	
    Volv_Field_WindowSizeBox->setEnabled((CURRENT_VOLUME->getMode()==2));
	//
	//  Paint panel widgets
	//    
    CALL_FUNCTION1(Volv_Paint_PaletteList,setCurrentItem,CURRENT_VOLUME->getPal());
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(CURRENT_VOLUME->getPal()),&myQT->pixmapPaint);
    Volv_Paint_PalettePixmap->setPixmap(myQT->pixmapPaint);
    
    CALL_FUNCTION1(Volv_Paint_MaterialShade,setChecked,CURRENT_VOLUME->getShade());
    
    f = CURRENT_VOLUME->getDiffuse();
    CALL_FUNCTION1(Volv_Paint_MaterialDiffuseSlider,setValue,round(100.0*f));
    Volv_Paint_MaterialDiffuseSlider->setEnabled(Volv_Paint_MaterialShade->isChecked());
    Volv_Paint_MaterialDiffuseLCD->display((double)f);
    
    f = CURRENT_VOLUME->getAmbient();
    CALL_FUNCTION1(Volv_Paint_MaterialAmbientSlider,setValue,round(100.0*f));
    Volv_Paint_MaterialAmbientSlider->setEnabled(Volv_Paint_MaterialShade->isChecked());
    Volv_Paint_MaterialAmbientLCD->display((double)f);
    
    f = CURRENT_VOLUME->getSpecular();
    CALL_FUNCTION1(Volv_Paint_MaterialSpecularSlider,setValue,round(100.0*f));
    Volv_Paint_MaterialSpecularSlider->setEnabled(Volv_Paint_MaterialShade->isChecked());
    Volv_Paint_MaterialSpecularLCD->display((double)f);
    
    f = CURRENT_VOLUME->getSpecularPower();
    CALL_FUNCTION1(Volv_Paint_MaterialSpecularPowerSlider,setValue,round(f));
    Volv_Paint_MaterialSpecularPowerSlider->setEnabled(Volv_Paint_MaterialShade->isChecked());
    Volv_Paint_MaterialSpecularPowerLCD->display((double)f);
	//
	//  Opacity panel widgets
	//
    updateVolv_Opaci_FunctionPixmap(0);
	//
	//  Advanced panel widgets
	//  
	int nn = CURRENT_VOLUME->getMode();
	if(nn == IVOLUME_MODE_TEXTURE) Volv_Advan_RaycastOptions->setEnabled(false); else Volv_Advan_RaycastOptions->setEnabled(true); 
	
    f = CURRENT_VOLUME->getZResample();
    Volv_Advan_ResampleZLCD->display((double)f);
    if(f == 1.0) v = 0; else if(f > 1.0) v = round(f)-1; else v = 1-round(1.0/f);
    CALL_FUNCTION1(Volv_Advan_ResampleZSlider,setValue,v);
    
    f = CURRENT_VOLUME->getXYResample();
    Volv_Advan_ResampleXYLCD->display((double)f);
    if(f == 1.0) v = 0; else if(f > 1.0) v = round(f)-1; else v = 1-round(1.0/f);
    CALL_FUNCTION1(Volv_Advan_ResampleXYSlider,setValue,v);
	
	CALL_FUNCTION1(Volv_Advan_CompositeMethodBox,setButton,(int)CURRENT_VOLUME->getCompositeMethod());
	CALL_FUNCTION1(Volv_Advan_InterpolationTypeBox,setButton,(int)CURRENT_VOLUME->getInterpolationType());
	CALL_FUNCTION1(Volv_Advan_BlendModeBox,setButton,CURRENT_VOLUME->getBlendMode());
	
    if(myQT->ext != NULL) myQT->ext->updateWidgets(DISPLAYPAGE_VOLV);
	myQT->updateDataChannelComboBox(DISPLAYPAGE_VOLV);

}


void iQT_Volv::updateVolv_Field_PrimaryBox( int v )
{

    v++;
    if(v>=1 && v<=CURRENT_LIMITS->getNvar() && v!=CURRENT_VOLUME->getVar()) 
	{
		myQT->startTask();
        CURRENT_VOLUME->setVar(v);
		this->updateVolv_Widgets(); // needed for the histogram in the opacity function window to display properly, & colorbars
 		myQT->render(true);
		myQT->endTask();
    }
    
}


void iQT_Volv::updateVolv_Field_Method( int n )
{

	myQT->startTask();

    int nn = CURRENT_VOLUME->changeMode(n);
    CALL_FUNCTION1(Volv_Field_MethodBox,setButton,nn);    
    Volv_Field_WindowSizeBox->setEnabled((CURRENT_VOLUME->getMode()==2));

    if(nn==IVOLUME_MODE_VOLUMEPRO && myQT->TabWidgetView->View_Volv->isChecked()) 
	{
		myQT->TabWidgetView->View_Projection->setEnabled(false);
		if(myQT->TabWidgetView->View_Projection->id(myQT->TabWidgetView->View_Projection->selected()) == 1) 
		{
			CALL_FUNCTION1(myQT->TabWidgetView->View_Projection,setButton,0);
			iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera()->ParallelProjectionOn(); 
			myQT->popupInfo("VolumePro board only suports the Orthogonal projection.\n Setting the projection to Orthogonal.\n");
		}
    } else myQT->TabWidgetView->View_Projection->setEnabled(true);

	if(nn == IVOLUME_MODE_TEXTURE) Volv_Advan_RaycastOptions->setEnabled(false); else Volv_Advan_RaycastOptions->setEnabled(true); 
	myQT->render(true);
	myQT->endTask();

}


void iQT_Volv::updateVolv_Field_WindowSize( int n )
{

    iVTKWindow::getCurrentWindow()->setWindowSizeButtonGroup(0);
    switch (n) 
	{
    case 1: { iVTKWindow::getCurrentWindow()->resize(256,256); break; }
    case 2: { iVTKWindow::getCurrentWindow()->resize(512,512); break; }
    case 3: { iVTKWindow::getCurrentWindow()->resize(1024,1024); break; }
    }
    //	myQT->startTask();
    //myQT->render(true);
    //myQT->endTask();
    iVTKWindow::getCurrentWindow()->setWindowSizeButtonGroup(Volv_Field_WindowSizeBox);

}


void iQT_Volv::updateVolv_Paint_PalettePixmap( int n )
{

    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(n),&myQT->pixmapPaint);
    Volv_Paint_PalettePixmap->setPixmap(myQT->pixmapPaint);

}


void iQT_Volv::updateVolv_Paint_PalettePixmapFinal( int n )
{
    
    int no = CURRENT_VOLUME->getPal();
    if(n != no ) 
	{
		myQT->startTask();
		updateVolv_Paint_PalettePixmap(n);
		CURRENT_VOLUME->setPal(n);
		updateVolv_Widgets(); // this is needed for the colorbars to change colors properly
        myQT->render(true);
		myQT->endTask();
    }
	
}


void iQT_Volv::updateVolv_Opaci_FunctionPixmap( QMouseEvent * e )
{

	int v = CURRENT_VOLUME->getVar();
    myQT->updateFunctionPixmap(e,CURRENT_VOLUME->getOpacityFunction(),Volv_Opaci_FunctionPixmap,cpVolv_Opaci_Function,CURRENT_VOLUME->getHistogramMaker()->getHistogram(0,false,CURRENT_LIMITS->getVarLow(v),CURRENT_LIMITS->getVarHigh(v)));

}


void iQT_Volv::updateVolv_Opaci_FunctionResButton()
{

    int n = CURRENT_VOLUME->getOpacityFunction()->getFunctionN();
    for(int i=0; i<n-2; i++) CURRENT_VOLUME->getOpacityFunction()->delFunctionPoint(1);
    CURRENT_VOLUME->getOpacityFunction()->movFunctionPoint(0,0.0,0.0);
    CURRENT_VOLUME->getOpacityFunction()->movFunctionPoint(1,1.0,1.0);
    cpVolv_Opaci_Function=0;
    updateVolv_Opaci_FunctionPixmap(0);
    
}

void iQT_Volv::updateVolv_Opaci_FunctionAddButton()
{

    CURRENT_VOLUME->getOpacityFunction()->addFunctionPoint(cpVolv_Opaci_Function);
    if(cpVolv_Opaci_Function <  CURRENT_VOLUME->getOpacityFunction()->getFunctionN()-1) cpVolv_Opaci_Function++;
    updateVolv_Opaci_FunctionPixmap(0);
    
}

void iQT_Volv::updateVolv_Opaci_FunctionDelButton()
{

    CURRENT_VOLUME->getOpacityFunction()->delFunctionPoint(cpVolv_Opaci_Function);
    if(cpVolv_Opaci_Function > 0) cpVolv_Opaci_Function--;
    updateVolv_Opaci_FunctionPixmap(0);
    
}


void iQT_Volv::updateVolv_Opaci_FunctionApply()
{

	myQT->startTask();
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Volv::updateVolv_Advan_ResampleZ( int n )
{
    float f;

    if(n > 0) f = 1.0+n; else if(n < 0) f = 1.0/(1-n); else f = 1.0;
    Volv_Advan_ResampleZLCD->display((double)f);
    CURRENT_VOLUME->setZResample(f);
    if(myQT->sliderRenderTracking) myQT->render(false);    
    
}


void iQT_Volv::updateVolv_Advan_ResampleXY( int n )
{
    float f;

    if(n > 0) f = 1.0+n; else if(n < 0) f = 1.0/(1-n); else f = 1.0;
    Volv_Advan_ResampleXYLCD->display((double)f);
    CURRENT_VOLUME->setXYResample(f);
    if(myQT->sliderRenderTracking) myQT->render(false);    
    
}


void iQT_Volv::updateVolv_Advan_BlendMode( int n )
{

	myQT->startTask();
    CURRENT_VOLUME->setBlendMode(n);
    myQT->render(true);    
	myQT->endTask();

}


void iQT_Volv::updateVolv_Advan_InterpolationType( int n )
{
    
	myQT->startTask();
    CURRENT_VOLUME->setInterpolationType((n!=0));
    myQT->render(true);    
	myQT->endTask();

}


void iQT_Volv::updateVolv_Advan_CompositeMethod( int n )
{

	myQT->startTask();
    CURRENT_VOLUME->setCompositeMethod((n!=0));
    myQT->render(true);    
	myQT->endTask();

}


void iQT_Volv::enableVolv_Advan_RaycastOptions( bool s )
{

    Volv_Advan_RaycastOptions->setEnabled(s);
    
}


void iQT_Volv::enableVolv_Advan_ResampleOptions( bool s )
{

    Volv_Advan_ResampleXYSlider->setEnabled(s);
    Volv_Advan_ResampleZSlider->setEnabled(s);
    
}


void iQT_Volv::updateVolv_Paint_MaterialShade( bool s )
{

	myQT->startTask();
    CURRENT_VOLUME->setShade(s);
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Volv::updateVolv_Paint_MaterialAmbientSlider( int n )
{

    CURRENT_VOLUME->setAmbient(0.01*n);
    Volv_Paint_MaterialAmbientLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Volv::updateVolv_Paint_MaterialDiffuseSlide( int n )
{

    CURRENT_VOLUME->setDiffuse(0.01*n);
    Volv_Paint_MaterialDiffuseLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Volv::updateVolv_Paint_MaterialSpecularSlider( int n )
{

    CURRENT_VOLUME->setSpecular(0.01*n);
    Volv_Paint_MaterialSpecularLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Volv::updateVolv_Paint_MaterialSpecularPower( int n )
{
    
    CURRENT_VOLUME->setSpecularPower((float)n);
    Volv_Paint_MaterialSpecularPowerLCD->display((double)n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Volv::updateVolv_Field_SecondaryFieldBox(int vtkNotUsed(v))
{
}


void iQT_Volv::updateVolv_Paint_SecondaryColorLabel()
{

/*	
    QColor c = QColorDialog::getColor(); 
	if(c.isValid())
	{
		Volv_Paint_SecondaryColorLabel->setBackgroundColor(c);
		CURRENT_VOLUME->setSecondaryColor(c);
		updateVolv_Widgets(); 
	}
*/
    
}


void iQT_Volv::launchPaletteEditor()
{
	
	myQT->launchPaletteEditor(Volv_Paint_PaletteList->currentItem());
	
}


void iQT_Volv::updateTabPageChanged(QWidget *)
{
	myQT->updateDataChannelComboBox(DISPLAYPAGE_VOLV);
}


