/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
// *********************************************************************************
//
//  
//   Additional header for the implementation of iQT classes
//
//
// *********************************************************************************
//

#define CURRENT_SURFACE   iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMember()
#define CURRENT_XSECTION  iVTKWindow::getCurrentWindow()->getXsectionFamily()->getCurrentMember()
#define CURRENT_VOLUME    iVTKWindow::getCurrentWindow()->getVolumeFamily()->getCurrentMember()
#define CURRENT_PARTICLES iVTKWindow::getCurrentWindow()->getParticlesFamily()->getCurrentMember()
#define CURRENT_VECTOR    iVTKWindow::getCurrentWindow()->getVectorFamily()->getCurrentMember()
#define CURRENT_TENSOR    iVTKWindow::getCurrentWindow()->getTensorFamily()->getCurrentMember()

#define DISPLAYPAGE_VIEW				0
#define DISPLAYPAGE_SURF				1
#define DISPLAYPAGE_XSEC				2
#define DISPLAYPAGE_VOLV				3
#define DISPLAYPAGE_PART				4
#define DISPLAYPAGE_VECT				5
#define DISPLAYPAGE_TENS				6
#define DISPLAYPAGE_DATA				7

#define FILEREADERRORMODE_MESH			1
#define FILEREADERRORMODE_PART			2				
#define FILEREADERRORMODE_VECT			4				
#define FILEREADERRORMODE_TENS			8				
//
//  Macro for setting widget parameters without emitting signals
//
#define CALL_FUNCTION0(obj,fun) { if(obj->signalsBlocked()) { obj->fun(); } else { obj->blockSignals(true); obj->fun(); obj->blockSignals(false); } } 
#define CALL_FUNCTION1(obj,fun,val) { if(obj->signalsBlocked()) { obj->fun(val); } else { obj->blockSignals(true); obj->fun(val); obj->blockSignals(false); } } 
#define CALL_FUNCTION2(obj,fun,val1,val2) { if(obj->signalsBlocked()) { obj->fun(val1,val2); } else { obj->blockSignals(true); obj->fun(val1,val2); obj->blockSignals(false); } } 

