/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "isurfaceshifter.h"

#include <vtkFloatArray.h>
#include <vtkPolyData.h>
#include <vtkPointData.h>


//--------------------------------------------------------------------------
iSurfaceShifter* iSurfaceShifter::New()
{
	return new iSurfaceShifter;
}


iSurfaceShifter::iSurfaceShifter()
{
	
	shift = 0.003;

}


iSurfaceShifter::~iSurfaceShifter()
{
	
}


void iSurfaceShifter::setShift(float s)
{
	shift = s;
	this->Modified();
}


void iSurfaceShifter::ExecuteData(vtkDataObject *)
{
	vtkPolyData *input = this->GetInput();
	vtkPolyData *output = (vtkPolyData *)this->GetOutput();

	if(input == 0) return;

	output->DeepCopy(input);

	if(fabs(shift) < 1.0e-30) return;

	vtkFloatArray *nor = (vtkFloatArray *)output->GetPointData()->GetNormals();
	vtkPoints *poi = output->GetPoints();

	vtkIdType n = nor->GetNumberOfTuples();
	if(n != poi->GetNumberOfPoints()) return;

	float *xptr = (float *)poi->GetVoidPointer(0);
	float *nptr = (float *)nor->GetVoidPointer(0);

	vtkIdType l; 
	for(l=0; l<3*n; l++) xptr[l] += shift*nptr[l];

}

