/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

This file is derived from the file TOOLS\DESIGNER\plugins\cppeditor\syntaxhighliter_cpp.cpp of the
Qt distribution, and fully inherits QT license conditions.

Unmodified parts of the Qt file retain Qt Copyright.

=========================================================================*/
/**********************************************************************
**
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef ISYNTAXHIGHLIGHTER_H
#define ISYNTAXHIGHLIGHTER_H

#include <private/qrichtext_p.h>

#ifndef QT_VERSION
   #error "QT_VERSION is not defined."
   $TERMINATE$
#endif

#if (QT_VERSION > 0x030004)
  #define QTextParag QTextParagraph
#endif


class iSyntaxHighlighter : public QTextPreProcessor
{
public:
    enum CppIds {
	Comment = 1,
	Number,
	String,
	Keyword,
	Variable,
	Parameter
    };

    iSyntaxHighlighter();
    virtual ~iSyntaxHighlighter();
    void process(QTextDocument *doc, QTextParag *string, int start, bool invalidate = true);

	void setKeywords(QStringList k){ keywords = k; }
	void setVariables(QStringList v){ variables = v; }
	void setParameters(QStringList p){ parameters = p; }

	void setPointSize(int s);

	void activate(bool s);

    QTextFormat *format( int id );

private:

    void addFormat(int id, QTextFormat *f);
    void removeFormat(int id );

	QStringList keywords, variables, parameters;

    QTextFormat *lastFormat;
    int lastFormatId;
    QIntDict<QTextFormat> formats;

	bool highlightOn;

};

#endif
