/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
**
** iTrackball widget description: inherits QLabels and add mouse sensitivity
**
*****************************************************************************/

#ifndef ITRACKBALL_H
#define ITRACKBALL_H

#include <qkeysequence.h>
#include <qevent.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qcolor.h>


class iTrackball : public QWidget
{
    Q_OBJECT

public:

    iTrackball( QWidget *parent=0, const char *name=0 );
    virtual ~iTrackball();

    virtual void mouseMoveEvent( QMouseEvent *);
    virtual void mousePressEvent( QMouseEvent *);
    virtual void mouseReleaseEvent( QMouseEvent *);
	virtual void paintEvent (QPaintEvent *){ this->doUpdate(); }
	virtual void setSpeed(float s);
	virtual float getSpeed(){ return speed; }

public slots:

	virtual void setDirection(float x, float y, float z);
	virtual void setAngles(float l1, float l2);

signals:

    void direction(float x, float y, float z);
    void angles(float l1, float l2);
	void trackballPressed();
	void trackballReleased();

private:

	bool clipAngles(float &l1, float &l2);
	void doUpdate();
	QColor colorAtLonLat(float l1, float l2);

	QPainter painter;

	float lon, lat;
	int oldX, oldY;
	float speed, latDir;

	float lightDeltaX, lightDeltaY;

	float ex[3], ey[3], ez[3];

};

#define PI		(float)3.1415926535897932384626433832795
#define TWOPI	((float)2.0*PI)
#define HALFPI	((float)0.5*PI)


inline bool iTrackball::clipAngles(float &l1, float &l2){
	bool dirChange = false;
	if(l2 < -HALFPI) { l2 = -PI - l2; l1 += PI; dirChange = true; }
	if(l2 >= HALFPI) { l2 =  PI - l2; l1 += PI; dirChange = true; }
	if(l1 <     -PI) l1 += TWOPI;
	if(l1 >=     PI) l1 -= TWOPI;
	return dirChange;
}


#endif // ITRACKBALL_H
