/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
A small set of common functionality for all IFRIT visualization objects
*/

#ifndef IVISUALOBJECT_H
#define IVISUALOBJECT_H

class iVTK;
class iDataReader;
class iVisualObjectObserver;
class iLimits;


#include "iobject.h"
#include "idatachannelsource.h"


class iVisualObject :  public iObject, public iDataChannelSource
{
	
public:
	
	iVisualObject(iVTK *m);
	virtual ~iVisualObject();
	
	inline bool getClipPlaneOn(){ return clipPlaneOn; }
	
	inline bool getShade(){ return shade; }
	inline float getAmbient(){ return ambient; }
	inline float getDiffuse(){ return diffuse; }
	inline float getSpecular(){ return specular; }
	inline float getSpecularPower(){ return specularPower; }
	
	virtual void setShade(bool){ }
	virtual void setAmbient(float v) = 0;
	virtual void setDiffuse(float v) = 0;
	virtual void setSpecular(float v) = 0;
	virtual void setSpecularPower(float v) = 0;
	
	virtual void showClipPlane(bool s) = 0;
	virtual void showColorBars(bool s) = 0;

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual bool isInitialized(){ return !init; }

	virtual void setDataChannel(int c);
	virtual void setDataStream(int s);

	virtual iLimits* getLimits();

	virtual void show(bool s) = 0;

	virtual void reset() = 0;

	virtual float getMemorySize() = 0;

protected:
	
	virtual void updateDataChannel(){}

	iVisualObjectObserver *objectObserver;

	bool init;
	bool clipPlaneOn;
	//
	//  Material properties
	//
	bool shade;
	float ambient;
	float diffuse;
	float specular;
	float specularPower;

};

#endif // IVISUALOBJECT_H

