/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVTK_H
#define IVTK_H


//
//  Necessary evil: explicit dependence on QT
//
class QEvent;
class QWidget;
class QButtonGroup;
class QImage;
class iDialogPopup;
class iDialogImageComposer;

class vtkRenderer;
class vtkRenderWindow;
class vtkRenderWindowInteractor;
class vtkRenderLargeImage;
class vtkCylinderSource;
class vtkCubeSource;
class vtkPolyData;
class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class vtkLightKit;
class vtkImageWriter;
class vtkImageData;
class vtkIntArray;
class vtkInteractorStyleTrackballCamera;
class vtkInteractorStyleFlight;
class vtkArrowSource;
class vtkPlane;
class vtkProp;
class vtkPropCollection;
class vtkActor2D;
class vtkPolyDataMapper2D;
class vtkCoordinate;
class vtkDiskSource;
class vtkSphereSource;
class vtkPointWidget;
class vtkInteractorObserver;
class vtkViewport;

class iColor;
class iVTKProgressEventObserver;
class iVTKStartEventObserver;
class iVTKEndEventObserver;
class iVTKAbortRenderEventObserver;
class iVTKPickEventObserver;
class iVTKRecordEventObserver;
class iDataReader;
class iDataGateway;
class iAnimator;
class iRuler;
class iMeasuringBox;
class iMeasuringBoxInteractorStyle;
class iColorBars;
class iTextActor;
class iParticlesSplitter;
class iLimits;
class iLightKit;
class iCubeAxesActor;
class iPicker;
class iInteractorEventRecorder;
class iMarkerEventObserver;
class iLegend;
class iCaptionInteractorStyle;
class iScaledLODActor;

class iSurface;
class iXsection;
class iVolume;
class iParticles;
class iVector;
class iTensor;

class iMarker;


#include "istring.h"
#include "irenderwindow.h"
#include "irenderwindowinteractor.h"
#include "ivisualobjectfamily.h"
#include "iobject.h"


#define I_IMAGETYPE_JPG	0
#define I_IMAGETYPE_PNM	1
#define I_IMAGETYPE_BMP	2
#define I_IMAGETYPE_PNG	3
#define I_IMAGETYPE_TIF	4
#define I_IMAGETYPE_PS	5
#define I_IMAGETYPE_MAX	5

#define I_IMAGE_SNAPSHOT	0
#define I_IMAGE_ANIFRAME	1

#define I_ICON_NONE		0
#define I_ICON_CLONE	1
#define I_ICON_FULL		2


class iVTK : public iRenderWindow, public iObject
{
	
	friend class iQT;
	friend class iObjectFactory;

public:

	static iVTK* New(iVTK *m = 0);
	virtual ~iVTK();

	static iVTK* convertFromViewport(vtkViewport *);
	static void blockEvents(bool s){ eventsBlocked = s; };

	int getId(){ return id; }

	virtual void ReInitialize(){ mInitialized = false; }

	virtual void setWindowNumber(int n);
	inline int getWindowNumber(){ return windowNumber; }

	virtual void Render();  //  vtk-style Render call

	virtual void render(bool s = true);
	void setUpdateRate(float r);
	inline float getUpdateRate(){ return rate; }
	
	inline int getBoxType(){ return boxType; } 
	void setBoxType(int t); 
	void setBox3Axes(char *labelX, char *labelY, char *labelZ, float xMin, float xMax, float yMin, float yMax, float zMin, float zMax); 

	inline int* getWindowPosition(){ return win->GetPosition(); } 
	inline int* getWindowSize(){ return win->GetSize(); }
	inline vtkRenderWindow* getWindow(){ return win; }
	inline vtkRenderWindowInteractor* getInteractor(){ return iren; }
	inline vtkRenderer* getRenderer(){ return ren; }
	inline iVTKStartEventObserver* getStartEventObserver(){ return obsStart; }
	inline iVTKProgressEventObserver* getProgressEventObserver(){ return obsProgress; }
	inline iVTKEndEventObserver* getEndEventObserver(){ return obsEnd; }
	inline iVTKPickEventObserver* getPickEventObserver(){ return obsPick; }
	inline iVTKRecordEventObserver* getRecordEventObserver(){ return obsRecord; }
	inline iVTKAbortRenderEventObserver* getAbortRenderEventObserver(){ return obsAbortRender; }
	inline iLightKit* getLightKit(){ return lights; } 
	inline bool isInteractorStyleFlight(){ return isFlight; }
	inline bool isParallelProjection(){ return parallelProjection; }
	inline vtkPropCollection* getObjectCollection(){ return objectCollection; }
	inline iPicker *getPicker(){ return picker; }

	virtual void addProp(vtkProp* p);
	virtual void removeProp(vtkProp* p);

	inline iAnimator* getAnimator(){ return animator; }
	inline iDataReader* getReader(){ return dataReader; }
	inline iDataGateway* getGateway(){ return dataGateway; }
	
	inline vtkImageWriter* getWriter(){ return writer; }
	inline int getImageType() { return imageType; }

	inline iInteractorEventRecorder* getEventRecorder(){ return eventRecorder; }

	void setBackgroundColor(iColor c);
	iColor getBackgroundColor();

	void setInteractorStyleFlight(bool s);
	void setParallelProjection(bool s);

	void setImageType(int t);
	virtual int dumpImage(int m = I_IMAGE_SNAPSHOT, vtkImageData *data = 0);
	int createImageData(vtkImageData* &data);
	virtual int renderImageData(vtkImageData* &data);
	void setImageMagnification(int m);
	inline int getImageMagnification(){ return imageMagnification; }
	inline int getImageMethod(){ return imageMethod; }

	virtual void showBox(bool s);
	virtual void showRuler(bool s);
	virtual void showLabel(bool s, float *v = 0);
	virtual void showMeasuringBox(bool s);
	virtual void showColorBars(bool s);
	virtual void showClipPlane(bool s);
	virtual void showGlassClipPlane(bool s);

	inline bool isLabelVisible(){ return isLabelOn; }
	inline bool isColorBarsVisible(){ return isColorBarsOn; }
	inline bool isBoundingBoxVisible(){ return isBoundingBoxOn; }
	inline bool isRulerVisible(){ return isRulerOn; }
	inline bool isMeasuringBoxVisible(){ return isMeasuringBoxOn; }
	inline bool isClipPlaneVisible() { return isClipPlaneOn; }
	inline bool isGlassClipPlaneVisible() { return isGlassClipPlaneOn; }

	void updateLabel(float *v = 0){ this->showLabel(isLabelOn,v); }
	void justifyLabelLeft(bool s);

	virtual void updateGL();
	virtual void resetGL();
	virtual void resetCamera();

	inline iTextActor *getTimeLabelActor(){ return labelActor; }
	inline iMeasuringBox *getMeasuringBox(){ return measuringBox; }
	inline iColorBars* getColorBars(){ return colorBars; }
	inline vtkPlane *getClipPlane(){ return clipPlane; }
	inline vtkActor *getGlassClipPlane(){ return clipPlaneActor; }

	void setFontSize(int s);
	void setFontType(int s);
	inline int getFontSize(){ return fontSize; }
	inline int getFontType(){ return fontType; }

	virtual void setAntialiasingOn(bool s);
	inline bool isAntialiasingOn(){ return antialiasing; }

	void setAutoRaiseOn(bool s){ autoRaise = s; }
	inline bool isAutoRaiseOn(){ return autoRaise; }
	void setCurrentWindowUnderFocusOn(bool s){ focusCurrent = s; }
	inline bool isCurrentWindowUnderFocusOn(){ return focusCurrent; }
	void setBroadcastMouseEventsOn(bool s){ broadcastMouseEvents = s; }
	inline bool isBroadcastMouseEventsOn(){ return broadcastMouseEvents; }

	virtual void showIcon(int iconMode);
	virtual void showPickedPoint(bool s, float bs = -1.0, double *pos = 0);
	virtual void setPickedPointSize(float size);
	inline float getPickedPointSize(){ return pickedPointSize; }

	virtual bool becomeClone(iVTK *v);
	inline bool isClone(){ return clone; }

	virtual void setDebugMode(bool s);

	virtual void setBoxSize(float s);
	inline float getBoxSize(){ return fabs(boxSize); }
	void useOpenGLCoordinates(bool s);
	inline bool isUsingOpenGLCoordinates(){ return boxSize < 0.0; }

	double transformToInternalCoordinate(double x);
	double transformToExternalCoordinate(double x);
	void transformToInternalCoordinate(int n, double *x);
	void transformToExternalCoordinate(int n, double *x);
	void transformToInternalCoordinate(int n, double *src, double *dest);
	void transformToExternalCoordinate(int n, double *src, double *dest);

	inline bool isMarkerLegendShown(){ return markerLegendOn; }
	inline int getMarkerLegendPosition(){ return markerLegendPosition; }
	virtual void placeMarker(bool s);
	virtual void moveMarkerCaption(bool s);
	virtual void showMarkerLegend(bool s);
	virtual void buildMarkerLegend(int i = -1);
	virtual void setMarkerLegendPosition(int p);

	inline void resetAnimationImageIndex(){ im_acur = 1; }

	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();
//
//  iVisualObject-related functions
//
	inline iVisualObjectFamily<iSurface>   *getSurfaceFamily(){ return surfaceFamily; }
	inline iVisualObjectFamily<iXsection>  *getXsectionFamily(){ return xsectionFamily; }
	inline iVisualObjectFamily<iVolume>    *getVolumeFamily(){ return volumeFamily; }
	inline iVisualObjectFamily<iVector>    *getVectorFamily(){ return vectorFamily; }
	inline iVisualObjectFamily<iTensor>    *getTensorFamily(){ return tensorFamily; }

	virtual iVisualObjectFamily<iParticles> *getParticlesFamily();
	virtual iVisualObjectFamily<iParticles> *getParticlesFamily(int dc, int ds);
	virtual void setCurrentParticlesFamily(int dc, int ds);
	virtual void setCurrentParticlesFamily(int dc);
	virtual iParticlesSplitter* getParticlesSplitter(int dc, int ds);
	virtual iParticlesSplitter* getCurrentParticlesSplitter();

	inline iVisualObjectFamily<iMarker> *getMarkerFamily(){ return markerFamily; }

	virtual void synchronizeObjectsAndData();

	void computePositionShiftsUnderMagnification(int winij[2], vtkViewport *viewport);
	inline int getRenderingMagnification(){ return renMagnification; }

	virtual int getFullImageWidth();  // get the image size from Image Composer
	virtual int getFullImageHeight();
	virtual int getThisImageWidth();  // get the image size of this window only
	virtual int getThisImageHeight();

//
//  These function performed the feedback from iVTK to iQT. They are implemented
//  in a separate file ivtk-iqt.cpp to isolate the main iVTK body (QT independent
//  except for the inheritance) from the QT-dependent event handles.
//
	virtual bool event(QEvent *e);
	virtual void closeEvent(QCloseEvent *e);
	virtual void enterEvent(QEvent *e);
	virtual void leaveEvent(QEvent *e);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void moveEvent(QMoveEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);

	void setImageComposer(iDialogImageComposer *ic);
	inline void setCloseable(){ closeable = true; }
	inline void setBottomWidget(QWidget *wb){ bottomWidget = wb; }
	inline void setWindowSizeButtonGroup(QButtonGroup *bg){ windowSizeButtonGroup = bg; }
	inline void setWindowTileButtonGroup(QButtonGroup *bg){ windowTileButtonGroup = bg; }
	
//
//  Convinient image manipulation functions (some use Qt). In principle,
//  they can be moved to any other place
//
	static bool loadImageFromFile(iString filename, vtkImageData* data);
	static QImage loadImageFromFile(iString filename);
	static void scaleImage(vtkImageData* data, int w, int h);
	static void convertImage(vtkImageData *, QImage &);
	static void convertImage(QImage, vtkImageData *);


protected:
	
	iVTK(QWidget *parent = 0, const char *name = 0);

	void startRender();
	void endRender();

	virtual void createImageByMethod1();
	virtual int isReadyForDumpingImage();
	virtual void reportDumpImageError();

	static int im_icur, im_acur;
	static iString im_inam, im_anam;
	static int idCounter;
	static bool endiness;
	//
	// window-related members
	//
	static bool autoRaise, focusCurrent, broadcastMouseEvents, eventsBlocked;
	
	int imageType, windowNumber, id;

	int fontSize, fontType;
	int boxType;
	int imageMagnification;
	int imageMethod;

	bool isFlight, isDebug, clone;
	bool parallelProjection;
	bool blockRender;

	bool isLabelOn, isColorBarsOn, isBoundingBoxOn, isRulerOn, isMeasuringBoxOn;
	bool isGlassClipPlaneOn, isClipPlaneOn, antialiasing;

	int longRenderProgress;
	float lastRenderTime;

	iRenderWindow *win;
	iRenderWindowInteractor *iren;
	vtkRenderer *ren;
	vtkImageWriter *writer;
	vtkImageData *imageData;

	iInteractorEventRecorder *eventRecorder;

	vtkPropCollection *objectCollection, *objectCollectionVisible;
	
	iDataReader *dataReader;
	iDataGateway *dataGateway;
	iAnimator *animator;
	iParticlesSplitter *particlesSplitter;

	float rate, boxSize;
	
	vtkArrowSource *debugArrowSource[3];
	vtkPolyDataMapper *debugMapper[3];
	vtkActor *debugActor[3];
	
	vtkCylinderSource *box1Source[12];
	vtkPolyDataMapper *box1Mapper[12];
	vtkActor *box1Actor[12];
	
	vtkPolyData *box2Source;
	vtkPolyDataMapper *box2Mapper;
	vtkActor *box2Actor;
	vtkIntArray *box2Scalars;
	
	vtkArrowSource *box3ArrowSource[3];
	vtkCylinderSource *box3CylinderSource[9];
	vtkPolyDataMapper *box3Mapper[12];
	vtkActor *box3Actor[12];
	iCubeAxesActor *box3Cube;
	
	iScaledLODActor *pickedPointActor;
	vtkPolyDataMapper *pickedPointMapper;
	vtkSphereSource *pickedPointSource;
	vtkCubeSource *pickedPointSource2;
	float pickedPointSize;

	vtkActor2D *iconActor;
	vtkPolyDataMapper2D *iconMapper;
	vtkCoordinate *iconCoordinate;
	vtkDiskSource *iconSource;

	iRuler *rulerActor;
	iTextActor *labelActor;
	iMeasuringBox* measuringBox;
	iColorBars *colorBars;

	iPicker *picker;

	bool labelJustificationLeft;

	iLightKit *lights;
	
	vtkPlane *clipPlane;
	vtkPolyData *clipPlaneSource;
	vtkPolyDataMapper *clipPlaneMapper;
	vtkActor *clipPlaneActor;

	vtkInteractorStyleFlight *istyleFlight;
	vtkInteractorStyleTrackballCamera *istyleView;
	iMeasuringBoxInteractorStyle* istyleMeasuringBox;
	iCaptionInteractorStyle *istyleCaption;
	vtkInteractorObserver *prevIstyle;

	iVTKStartEventObserver *obsStart;
	iVTKProgressEventObserver *obsProgress;
	iVTKEndEventObserver *obsEnd;
	iVTKAbortRenderEventObserver *obsAbortRender;
	iVTKPickEventObserver *obsPick;
	iVTKRecordEventObserver *obsRecord;

	vtkPointWidget *markerPlacer;
	iLegend *markerLegend;
	iMarkerEventObserver *markerEventObserver;
	bool markerLegendOn;
	int markerLegendPosition;

	vtkRenderLargeImage *magnifier;
	int renMagnification;

//
//  iVisualObject-related members
//
	iVisualObjectFamily<iSurface>   *surfaceFamily; 
	iVisualObjectFamily<iXsection>  *xsectionFamily; 
	iVisualObjectFamily<iVolume>    *volumeFamily; 
	iVisualObjectFamily<iParticles> *particlesFamily; 
	iVisualObjectFamily<iVector>    *vectorFamily; 
	iVisualObjectFamily<iTensor>    *tensorFamily; 

	iVisualObjectFamily<iMarker>    *markerFamily; 
//
//  Helper for broadcasting interactor events to all windows
//
	bool inBroadcast;
//
//  QT-dependent members. Classes are declared as such (when possible), and not as pointers,
//  to emphasize the difference with the rest of iVTK.
//
	iDialogPopup *popupDialog;
	static QWidget *bottomWidget;
	static QButtonGroup *windowSizeButtonGroup;
	static QButtonGroup *windowTileButtonGroup;
	iDialogImageComposer *imageComposer;
	
	bool closeable;
	
};

#endif // IVTK_H

