/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
**  Defines the IFRIT thread with graphical initialization
*/

#ifndef IVTKCALLBACK_H
#define IVTKCALLBACK_H

class iDialogPick;
class iDialogEventRecorder;
class iDialogProgress;

class QProgressBar;

class vtkObject;
class vtkProcessObject;
class vtkRenderWindow;


#include <vtkCommand.h>


class iVTKProgressEventObserver : public vtkCommand
{
	
public:
	
	static iVTKProgressEventObserver *New() { return new iVTKProgressEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);
	void setProgressBar(QProgressBar *p);

protected:

	iVTKProgressEventObserver(){ pb = 0; }
	
private:

	QProgressBar *pb;
	
};


class iVTKStartEventObserver : public vtkCommand
{
	
public:
	
	static iVTKStartEventObserver *New() { return new iVTKStartEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);
	virtual void setProgressBar(QProgressBar *p);

protected:

	iVTKStartEventObserver(){ pb = 0; }
	
private:

	QProgressBar *pb;
	
};


class iVTKEndEventObserver : public vtkCommand
{
	
public:
	
	static iVTKEndEventObserver *New() { return new iVTKEndEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);
	virtual void setProgressBar(QProgressBar *p);

protected:

	iVTKEndEventObserver(){ pb = 0; }
	
private:

	QProgressBar *pb;
	
};


class iVTKAbortRenderEventObserver : public vtkCommand
{
	
public:
	
	static iVTKAbortRenderEventObserver *New() { return new iVTKAbortRenderEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);

	virtual void setProgressDialog(iDialogProgress *p);
	virtual void setRenderWindow(vtkRenderWindow *r);
	virtual void start();
	virtual void finish();
	virtual void docheck();

protected:

	iVTKAbortRenderEventObserver(){ rw = 0; pd = 0; }
	
private:
	
	vtkRenderWindow *rw;
	iDialogProgress *pd;
	
};


class iVTKPickEventObserver : public vtkCommand
{
	
public:
	
	static iVTKPickEventObserver *New() { return new iVTKPickEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);
	virtual void setDialogPick(iDialogPick *p);

protected:

	iVTKPickEventObserver(){ dialog = 0; }

private:

	iDialogPick *dialog;
	
};


class iVTKRecordEventObserver : public vtkCommand
{
	
public:
	
	static iVTKRecordEventObserver *New() { return new iVTKRecordEventObserver; }

	virtual void Execute(vtkObject *caller, unsigned long, void *callData);
	virtual void setDialogEventRecorder(iDialogEventRecorder *p);

protected:

	iVTKRecordEventObserver(){ dialog = 0; }

private:

	iDialogEventRecorder *dialog;
	
};


#endif // IVTKCALLBACK_H

