/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"

#ifdef IEXTENSION

#include "iextensionfactory.h"


#include "ianimatorscript.h"
#include "icontrolmodule.h"
#include "icrosssectionviewobject.h"
#include "idata.h"
#include "idataexplorer.h"
#include "idatareader.h"
#include "iedition.h"
#include "imarkerviewobject.h"
#include "iobject.h"
#include "iparticlegroup.h"
#include "iparticlesviewobject.h"
#include "ipicker.h"
#include "irendertool.h"
#include "isurfaceviewobject.h"
#include "itensorfieldviewobject.h"
#include "ivectorfieldviewobject.h"
#include "iviewmodule.h"
#include "ivolumeviewobject.h"

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
#include "hobjects.h"
#endif

#if IEXTENSION_INCLUDED(IEXTENSION_MV)
#include "imultiviewrendertool.h"
#endif

//
// **************************************************************************
//
//  IMPORTANT: Factory methods do not need to be checked for null pointers
//             since they are only called from within New() functions
//
// **************************************************************************
//

iAnimatorScript* iExtensionFactory::CreateAnimatorScript(iAnimator *m)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	return new hAnimatorScript(m);
#else
	return new iAnimatorScript(m);
#endif
}


iControlModule* iExtensionFactory::CreateControlModule(iShell *s)
{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	return new hControlModule(s);
#else
	return new iControlModule(s);
#endif
}


iObject* iExtensionFactory::CreateObject(const iObjectType &type, iViewModule *vm)
{
	iObject *obj = 0;

	//
	//  Other objects
	//
	if(type.IsMatch(iDataExplorer::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hDataExplorer(vm,iDataType::UniformScalars()+iDataType::UniformVectors()+iDataType::UniformTensors()+iDataType::BasicParticles()+hDataType::HARTVariables()+hDataType::HARTParticles()+hDataType::HARTParticles(1)+hDataType::HARTParticles(2));
#else
		obj = new iDataExplorer(vm,iDataType::UniformScalars()+iDataType::UniformVectors()+iDataType::UniformTensors()+iDataType::BasicParticles());
#endif
	}

	if(type.IsMatch(iDataReader::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hDataReader(vm);
#else
		obj = new iDataReader(vm);
#endif
	}

	if(type.IsMatch(iPicker::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hPicker(vm);
#else
		obj = new iPicker(vm);
#endif
	}

	//
	//  Visual objects
	//
	if(type.IsMatch(iCrossSectionViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hCrossSectionViewObject(vm,iDataType::UniformScalars()+hDataType::HARTVariables());
#else
		obj = new iCrossSectionViewObject(vm,iDataType::UniformScalars());
#endif
	}

	if(type.IsMatch(iParticleGroup::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hParticleGroup(vm,iDataType::BasicParticles()+hDataType::HARTParticles());
#else
		obj = new iParticleGroup(vm,iDataType::BasicParticles());
#endif
	}

	if(type.IsMatch(iParticlesViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hParticlesViewObject(vm,iDataType::BasicParticles()+hDataType::HARTParticles());
#else
		obj = new iParticlesViewObject(vm,iDataType::BasicParticles());
#endif
	}

	if(type.IsMatch(iSurfaceViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hSurfaceViewObject(vm,iDataType::UniformScalars()+hDataType::HARTVariables());
#else
		obj = new iSurfaceViewObject(vm,iDataType::UniformScalars());
#endif
	}

	if(type.IsMatch(iTensorFieldViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hTensorFieldViewObject(vm,iDataType::UniformTensors()+hDataType::HARTVariables(2));
#else
		obj = new iTensorFieldViewObject(vm,iDataType::UniformTensors());
#endif
	}

	if(type.IsMatch(iVectorFieldViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hVectorFieldViewObject(vm,iDataType::UniformVectors()+hDataType::HARTVariables(1));
#else
		obj = new iVectorFieldViewObject(vm,iDataType::UniformVectors());
#endif
	}

	if(type.IsMatch(iVolumeViewObject::Type()))
	{
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
		obj = new hVolumeViewObject(vm,iDataType::UniformScalars()+hDataType::HARTVariables());
#else
		obj = new iVolumeViewObject(vm,iDataType::UniformScalars());
#endif
	}

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	if(type.IsMatch(hMeshViewObject::Type()))
	{
		obj = new hMeshViewObject(vm,hDataType::HARTVariables());
	}
#endif

	iEdition::ApplySettings(obj,type);

	return obj;
}


iRenderTool* iExtensionFactory::CreateRenderTool(iViewModule *vm)
{
#if IEXTENSION_INCLUDED(IEXTENSION_MV)
	return new iMultiViewRenderTool(vm);
#else
	return new iRenderTool(vm);
#endif
}


iViewModule* iExtensionFactory::CreateViewModule(iControlModule *cm)
{
	iViewModule *vm;

#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	vm = new hViewModule(cm);
#else
	vm = new iViewModule(cm);
#endif

	iEdition::ApplySettings(vm,iViewModule::Type());

	return vm;
}

#endif
