/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ibasescript.h"


iBaseScript::iBaseScript(iScript *parent) : iScript(parent)
{
	//
	//  Use only real arrays
	//
	mArraysAreReal = true;
	
	//
	//  IFrIT script are case-sensitive since the keys are
	//
	mCaseSensitive = true;

	//
	//  This is for embeding other scripts
	//
	mHeadOfLineContinuationString = "> ";
	mAppendSeparator = "%%";

	//
	//  Dummy words
	//
	this->CreateDummyWord("to"); 
	this->CreateDummyWord("then"); 
	this->CreateDummyWord("set"); 

	//
	//  Prefix words
	//
	this->CreatePrefixWord("var"); 
	this->CreatePrefixWord("for"); 

	//
	//  Command words
	//

	//
	//  Declarations
	//
	this->CreateCommandWord(iOperation::New(this,"var","int",1,"",iValue::_RelativeAddMult,iValue::NewInt(this),(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"var","bool",1,"",iValue::_Absolute,iValue::NewBool(this),(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"var","real",1,"",iValue::_RelativeAddMult,iValue::NewReal(this),(unsigned char)1));

	//
	//  Flow control operations
	//
	this->CreateCommandWord(iOperation::New(this,"","loop",1,iOperation::_Entry,0,iValue::NewInt(this),1,(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"for","$variable",1,iOperation::_Entry,iValue::NewInt(this),iValue::NewInt(this),1,(unsigned char)2));
	this->CreateCommandWord(iOperation::New(this,"","end",1,iOperation::_Exit,0,0,1,(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"","if",1,iOperation::_Entry,0,iValue::NewBool(this),2,(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"","else",1,iOperation::_EntryExit,0,0,2,(unsigned char)1));
	this->CreateCommandWord(iOperation::New(this,"","endif",1,iOperation::_Exit,0,0,2,(unsigned char)1));

	//
	//  Genuine assignment operations to local variables
	//
	this->CreateCommandWord(iOperation::New(this,"","$variable",1,iValue::_RelativeAddMult,iValue::NewInt(this),0,(unsigned char)0));
	this->CreateCommandWord(iOperation::New(this,"","$variable",1,iValue::_RelativeAddMult,iValue::NewBool(this),0,(unsigned char)0));
	this->CreateCommandWord(iOperation::New(this,"","$variable",1,iValue::_RelativeAddMult,iValue::NewReal(this),0,(unsigned char)0));
	this->CreateCommandWord(iOperation::New(this,"","$variable",1,iValue::NewIndex(this),iValue::_RelativeAddMult,iValue::NewArray(this,3),0,(unsigned char)0));

}


iBaseScript::~iBaseScript()
{
}

