/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  This class encapsulates some of the console functions
//

#ifndef ICONSOLE_H
#define ICONSOLE_H


#include "ishellcomponent.h"


class iString;

class vtkTimerLog;

//
//  This is a singleton class - it can be inherited to get more console options
//
class iConsole : public iShellComponent
{

	friend class iShell;
	friend class iShellFactory;

public:

	static iConsole* Instance(){ return mInstance; }
	
	//
	//  Use these functions to report error and display text
	//
	void DisplayTextMessage(const char *message);
	void DisplayErrorMessage(const char *message, const char *file, int line);
	void DisplayFatalErrorMessage(const char *message, const char *file, int line);
	void DisplayCriticalInformationMessage(const char *message);

#ifdef I_DEBUG
	//
	//  Debugging helper
	//
	void BreakPoint(const char *file, int line);
	void StartTimer(int n = 0);
	void StopTimer(const iString &message, int n = 0);

	void OutputDebugMessage(const iString &message) const;
#endif

	//
	//  Checking whether the log has been created
	//
	iString GetLogFileName() const;
	inline bool IsLogCreated() const { return mLogCreated; }
	void BlockLogging(bool s);

protected:

	static void CreateInstance(iShell *);
	iConsole(iShell *);
	virtual ~iConsole();

	void UpdateLog(const iString &message, const iString &file, int line);

	bool mLogCreated, mInUpdateLog, mLoggingBlocked;

	//
	//  Inherit those in a shell
	//
	virtual void OutputText(const iString &message) const;
	virtual void OutputError(const iString &message, const iString &file, int line) const;
	virtual void OutputFatalError(const iString &message, const iString &file, int line) const;
	virtual void OutputCriticalInformation(const iString &message) const;

	static iConsole* mInstance;

#ifdef I_DEBUG
	vtkTimerLog *mTimer[10];
#endif
};

#endif  // ICONSOLE_H

